/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: fscspace.c
 * CvR
 *
 * Handling of close brackets around constructors and lists.
 */

/* Standard UNIX libraries. */
#include <stdio.h>
#include <ctype.h>

/* The header of this library */
#include "tmc.h"
#include "config.h"

/* line number counter */
int tmlineno;

/* Skip all `isspace()' characters and Miranda style comment.
   Note that since comment is introduced by '||' the pattern
   '|[^|]' causes grave problems. It is 'solved' by generating
   an error message and returning 1.
 */
int fscanspace( f )
 FILE *f;
{
    register int c;

    for(;;){
	c = getc( f );
	while( isspace( c ) ){
	    if( c == '\n' ) tmlineno++;
	    c = getc( f );
	}
	if( c != '|' ){
	    (void) ungetc( c, f );
	    break;
	}
	c = getc( f );
	if( c != '|' ){
	    (void) sprintf( tmerrmsg, "fscanspace(): single '|' found" );
	    return( 1 );
	}
	do{
	    c = getc( f );
	} while( c != '\n' );
	tmlineno++;
    }
    return( 0 );
}
