/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: newstr.c
   String manipulation routines.
 */

/* other standard UNIX functions */
#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "tmc.h"

#define PRSTAT(f,nm,new,fre) fprintf(f,"%-15s: %6ld allocated, %6ld freed.%s\n", nm, new, fre, ((new==fre)? "": "<-") );

static long newcnt_string = 0;
static long frecnt_string = 0;

/* Allocate space for string 's' and copy the text into it. */
string new_string( s )
 char *s;
{
    register unsigned int len;
    register char *adr;

    if( s == NULL ){
	return NULL;
    }
    len = ((unsigned) strlen( s )) + 1;
    adr = malloc( len );
    if( adr == NULL ){
	tmfatal( __FILE__, __LINE__, "no room" );
    }
    (void) strcpy( adr, s );
    newcnt_string++;
    return( adr );
}

/* de-allocate space for string 's'. */
void fre_string( s )
 char *s;
{
    if( s==NULL ) return;
    frecnt_string++;
    TMFREE( s );
}

/***********************************************************
 *   initalizing and statistics                            *
 ***********************************************************/

/* Give statistics */
void stat_string( f )
 FILE *f;
{
    PRSTAT( f, "string", newcnt_string, frecnt_string );
}
