/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: tmdebug.h
   Definitions for debugging.
 */

/* structure to describe debugging flags */
struct flagadrinfo {
    char flagchar;       /* char to switch the flag on */
    int *flagadr;        /* pointer to the flag */
    char *flagname;      /* description string */
};

extern void setdbflags();
extern void dbreport();
extern void dbhelp();

#ifdef STAT
#define PRSTAT(f,nm,new,fre) fprintf(f,"%-15s: %6ld allocated, %6ld freed.%s\n", nm, new, fre, ((new==fre)? "": "<-") );
#else
#define PRSTAT(f,nm,new,fre)
#endif

#define maintrace(str) if(maintr) fprintf(tracestream,"%s\n",str)

#ifdef DEBUG
#define hereiam() fprintf( stderr, "passing %s(%d)\n", __FILE__, __LINE__ );
#else
#define hereiam()
#endif
