/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* template file:      tmtplelm.ht
   datastructure file: tplelm.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)
 */

/* ---- start of /users/reeuwijk/esprit/lib/cllu.ht ---- */
/* External definitions (Version for linked list).

   template file:      /users/reeuwijk/esprit/lib/cllu.ht
   datastructure file: tplelm.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)
 */

/* datastructures */

typedef struct str_tplelm *tplelm_list;
typedef struct str_tplelm *tplelm;

#define Plain u.ue_Plain
#define Foreach u.ue_Foreach
#define While u.ue_While
#define If u.ue_If
#define Set u.ue_Set
#define Append u.ue_Append
#define Error u.ue_Error
#define Exit u.ue_Exit
#define Include u.ue_Include
#define Copy u.ue_Copy
#define Insert u.ue_Insert

typedef enum en_tags_tplelm {
    TAGPlain, TAGForeach, TAGWhile, TAGIf, TAGSet, TAGAppend, TAGError, TAGExit, TAGInclude, TAGCopy, TAGInsert
} tags_tplelm;


typedef struct str_Plain {
    int lno;
    string plainline;
} C_Plain;

typedef struct str_Foreach {
    int lno;
    string felist;
    tplelm_list felines;
} C_Foreach;

typedef struct str_While {
    int lno;
    string whilecond;
    tplelm_list whilelines;
} C_While;

typedef struct str_If {
    int lno;
    string ifcond;
    tplelm_list ifthen;
    tplelm_list ifelse;
} C_If;

typedef struct str_Set {
    int lno;
    string setline;
} C_Set;

typedef struct str_Append {
    int lno;
    string appline;
} C_Append;

typedef struct str_Error {
    int lno;
    string errstr;
} C_Error;

typedef struct str_Exit {
    int lno;
    string str;
} C_Exit;

typedef struct str_Include {
    int lno;
    string fname;
} C_Include;

typedef struct str_Copy {
    int lno;
    string fname;
} C_Copy;

typedef struct str_Insert {
    int lno;
    string fname;
} C_Insert;

/* Constructor type tplelm */
struct str_tplelm {
    tplelm next;
    tags_tplelm tag;
    union uni_tplelm {
	C_Plain ue_Plain;
	C_Foreach ue_Foreach;
	C_While ue_While;
	C_If ue_If;
	C_Set ue_Set;
	C_Append ue_Append;
	C_Error ue_Error;
	C_Exit ue_Exit;
	C_Include ue_Include;
	C_Copy ue_Copy;
	C_Insert ue_Insert;
    } u;
};


#define tplelmNIL (tplelm)0
#define tplelm_listNIL (tplelm_list)0

#if defined( __STDC__ ) && __STDC__ > 0
/* new_<cons> and new_<type> routines */
extern tplelm new_Plain( int, string );
extern tplelm new_Foreach( int, string, tplelm_list );
extern tplelm new_While( int, string, tplelm_list );
extern tplelm new_If( int, string, tplelm_list, tplelm_list );
extern tplelm new_Set( int, string );
extern tplelm new_Append( int, string );
extern tplelm new_Error( int, string );
extern tplelm new_Exit( int, string );
extern tplelm new_Include( int, string );
extern tplelm new_Copy( int, string );
extern tplelm new_Insert( int, string );

/* fre_<type> routines */

/* fre_<type>_list routines */

/* rfre_<type> routines */
extern void rfre_tplelm( tplelm );
extern void rfre_tplelm_list( tplelm );

/* app_<type>_list routines */

/* print_<type> routines */

/* fprint_<type> routines */

/* rdup_<type> routines */

/* fscan_<type> routines */

/* cmp_<type> routines */

extern void stat_tplelm( FILE * );

#else
/* new_<cons> and new_<type> routines */
extern tplelm new_Plain();
extern tplelm new_Foreach();
extern tplelm new_While();
extern tplelm new_If();
extern tplelm new_Set();
extern tplelm new_Append();
extern tplelm new_Error();
extern tplelm new_Exit();
extern tplelm new_Include();
extern tplelm new_Copy();
extern tplelm new_Insert();

/* fre_<type> routines */

/* fre_<type>_list routines */

/* rfre_<type> routines */
extern void rfre_tplelm();
extern void rfre_tplelm_list();

/* app_<type>_list routines */

/* print_<type> routines */

/* fprint_<type> routines */

/* rdup_<type> routines */

/* fscan_<type> routines */

/* cmp_<type> routines */

extern void stat_tplelm();

#endif
/* ---- end of /users/reeuwijk/esprit/lib/cllu.ht ---- */
