/*
   File: KindBox.c
   Implements a nice form widget
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include "XtArgs.h"
#include "KindBox.h"

static Widget current;
static Widget last_added, last_layer;
static WidgetClass last_class;

Widget CreateKindBox (name, parent)
 String name;
 Widget parent;
	{ current = XtCreateManagedWidget (name, formWidgetClass,
					parent, NoArgs);
	  last_added = NULL;
	  last_layer = NULL;
	  last_class = NULL;
	  return (current);
	}

void AddToKindBox (w)
 Widget w;
	{ WidgetClass this_class = XtClass(w);
	  if (this_class == last_class)
	     { /* Chain horizontal */
	       StartArgs;
	       SetArg (XtNfromHoriz, last_added);
	       XtSetValues (w, UseArgs);
	     }
	  else
	     { /* Finish Previous Layer */
	       if (last_added != NULL)
		  { /* Chain last widget to form */
	            StartArgs;
	            SetArg (XtNright, XtChainRight);
	            XtSetValues (last_added, UseArgs);
	          };
	       last_layer = last_added;
	     };
	
	  StartArgs;
	  SetArg (XtNfromVert, last_layer);
	  XtSetValues (w, UseArgs);
	
	  last_added = w;
	  last_class = this_class;
	};

void DoneKindBox()
	{ /* Chain last widget right to form */
	  StartArgs;
	  SetArg (XtNright, XtChainRight);
	  XtSetValues (last_added, UseArgs);
	}
