/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
-- SCCS Info: @(#)codegen.h	1.11 3/15/90

-- Various constants used in the code generator... generally you need
-- typemarks around them when they're used

#include "procenv.h"		/* get fixed process register */
				/* assignments */


-- There's an old version of the code generator that insists on
-- knowing the type of every object, even in cases where the type is
-- unimportant.  Of course, the type checker will always be able to
-- infer the type of unmarked expressions, but we don't want to depend
-- on the typechecker being available for the codegen boot process.
-- (To ensure type correctness we can always typecheck the hermes
-- sources once a stable compiler has been built.)  This all means
-- that we can't use syntax like x[i] for an ordered table x.  The
-- reason is that 'x[i]' is expanded by the front-end into something
-- like 'tmp in x where (predefined!boolean#(position of tmp = i)),
-- with no typemark on the 'position of' expression and no possibility
-- of inserting it in the hermes source.  So here's a macro to make
-- these 'position of' selectors convenient given that we can't use
-- the bracket syntax...
-- (following kludge is a workaround for a cpp bug under AIX on the Rios)
#define addspace(x,y) x y
#define AREF(elt,t,i) elt in t where (B(I(addspace(position of,elt)) = i))

-- number of different values that can be represented by a char...
-- used to choose representation of certain enumerations and
-- enumeration tables
#define SIZE_OF_CHARS	256

-- constants controlling allocations for vector-like tables
#define INITSIZE_CHAR	80
#define GROWTH_CHAR	256
#define INITSIZE_VEC	8
#define GROWTH_VEC	64

-- Shorthands for common long component lists
#define FNS args.cgData.Fns
#define CURBB args.cgData.Proc.curBB
#define BBDATA args.cgData.Proc.BBData
#define ABSPROG args.cgData.Prog.absprog

-- shorthands for certain common statement sequences

-- install the given instruction in the current basic block
#define ADDINSTR(instr) \
    insert interpform!operation@TYPEMARK@(instr) into CURBB.code

-- install a copy of the given template instruction in the current
-- basic block
#define ADDTPLT(name) \
    ADDINSTR(copy of args.cgData.Tplt.name)

-- install the current BB and begin a new one with the given ID
#define NEWBB(newid) \
    insert BBid@TYPEMARK@(copy of CURBB.id) into BBDATA.BBOrder; \
    insert CURBB into BBDATA.BBs; \
    new CURBB; \
    CURBB.id <- BBid@TYPEMARK@(newid); \
    new CURBB.code; \
    unite CURBB.exit.unknown from empty


