-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: makeopmap.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)makeopmap.pp	1.11 3/15/90

-- Run this program to generate opcode mappings for the Hermes code
-- generator.  The table is written (as a polymorph) to file
-- opmap.obj.

-- DIRECTMAP macro generates code to set up a DIRECT opcode mapping

#define DIRECTMAP(_hOp,_liOp) \
  new entry; \
  entry.hOP <- operator@TYPEMARK@'_hOp'; \
  unite entry.mapInfo.direct from interpform!opcode@TYPEMARK@'_liOp'; \
  insert entry into map

-- TYPEDMAP macro generates code to set up a TYPED opcode mapping.
-- All mappings for a given Hermes opcode must appear together,
-- preceded by an invocation of INITTYPEDMAP naming the Hermes opcode
-- being mapped, and followed by an invocation of DONETYPEDMAP.

#define INITTYPEDMAP(_hOp) \
  new entry; \
  entry.hOp <- predefined!operator@TYPEMARK@'_hOp'; \
  new tMap

#define TYPEDMAP(_hOp,_type,_liOp) \
  new tEntry; \
  tEntry.type <- predefined!primitive_types@TYPEMARK@'_type'; \
  tEntry.liOp <- interpform!opcode@TYPEMARK@'_liOp'; \
  insert tEntry into tMap

#define DONETYPEDMAP() \
  unite entry.mapInfo.typed from tMap; \
  insert entry into map

-- ADHOCMAP macro generates code to set up an ADHOC opcode mapping.
#define ADHOCMAP(_hOp,_modname) \
  new entry; \
  entry.hOp <- predefined!operator@TYPEMARK@'_hOp'; \
  unite entry.mapInfo.adhoc from charstring@TYPEMARK@"_modname"; \
  insert entry into map

makeOpMap: using (predefined, common, cgInternal, interpform, main)
process (Q: main_Q)
declare
  init: main_intf;
  map: opMap;
  entry: opMapEntry;
  tEntry: typedOpMapEntry;
  tMap: typedOpMap;
  poly: polymorph;
  empty: empty;
begin
  receive init from Q;
  new map;

  -- Build up the mapping table
  DIRECTMAP(and,and);
  DIRECTMAP(assert,assert);
  DIRECTMAP(attributename,attributename);
  DIRECTMAP(call,call);
  DIRECTMAP(case,case);
  DIRECTMAP(concatenate,concat);
  DIRECTMAP(connect,connect);
  DIRECTMAP(copy,copy);
  DIRECTMAP(create,create);
  DIRECTMAP(currentprogram,currentprogram);
  DIRECTMAP(discard,discard);
  DIRECTMAP(dissolve,dissolve);
  DIRECTMAP(empty,empty);
  DIRECTMAP(equal,equal);
  DIRECTMAP(exit,exit);
  DIRECTMAP(hide,hide);
  DIRECTMAP(insert,insert);
  DIRECTMAP(insert_at,insert_at);
  DIRECTMAP(integer_literal,ilit);
  DIRECTMAP(merge,merge);
  DIRECTMAP(merge_at,merge_at);
  DIRECTMAP(mod,imod);
  DIRECTMAP(move,move);
  DIRECTMAP(not,not);
  DIRECTMAP(not_equal,notequal);
  DIRECTMAP(or,or);
  DIRECTMAP(print,print);
  DIRECTMAP(procedure,procedure);
  DIRECTMAP(real_literal,rlit);
  DIRECTMAP(receive,receive);
  DIRECTMAP(rem,irem);
  DIRECTMAP(return,return);
  DIRECTMAP(return_exception,return_exception);
  DIRECTMAP(reveal,reveal);
  DIRECTMAP(send,send);
  DIRECTMAP(size,size);
  DIRECTMAP(string_literal,chs_lit);
  DIRECTMAP(type,type_of);
  DIRECTMAP(typename,typename);
  DIRECTMAP(typestate,typestate_of);
  DIRECTMAP(unique,unique);
  DIRECTMAP(unite,unite);
  DIRECTMAP(unwrap,unwrap);
  DIRECTMAP(wrap,wrap);
  INITTYPEDMAP(add);
    TYPEDMAP(add,integertype,iadd);
    TYPEDMAP(add,realtype,radd);
    DONETYPEDMAP();
  INITTYPEDMAP(divide);
    TYPEDMAP(divide,integertype,idivide);
    TYPEDMAP(divide,realtype,rdivide);
    DONETYPEDMAP();
  INITTYPEDMAP(greater);
    TYPEDMAP(greater,integertype,igt);
    TYPEDMAP(greater,realtype,rgt);
    TYPEDMAP(greater,enumerationtype,oegt);
    DONETYPEDMAP();
  INITTYPEDMAP(greater_equal);
    TYPEDMAP(greater_equal,integertype,ige);
    TYPEDMAP(greater_equal,realtype,rge);
    TYPEDMAP(greater_equal,enumerationtype,oege);
    DONETYPEDMAP();
  INITTYPEDMAP(less);
    TYPEDMAP(less,integertype,ilt);
    TYPEDMAP(less,realtype,rlt);
    TYPEDMAP(less,enumerationtype,oelt);
    DONETYPEDMAP();
  INITTYPEDMAP(less_equal);
    TYPEDMAP(less_equal,integertype,ile);
    TYPEDMAP(less_equal,realtype,rle);
    TYPEDMAP(less_equal,enumerationtype,oele);
    DONETYPEDMAP();
  INITTYPEDMAP(multiply);
    TYPEDMAP(multiply,integertype,imultiply);
    TYPEDMAP(multiply,realtype,rmultiply);
    DONETYPEDMAP();
  INITTYPEDMAP(subtract);
    TYPEDMAP(subtract,integertype,isubtract);
    TYPEDMAP(subtract,realtype,rsubtract);
    DONETYPEDMAP();
  INITTYPEDMAP(unary_minus);
    TYPEDMAP(unary_minus,integertype,inegate);
    TYPEDMAP(unary_minus,realtype,rnegate);
    DONETYPEDMAP();
  ADHOCMAP(block,cgblock);
  ADHOCMAP(checkdefinitions,cgstmtstub);-- NYI
  ADHOCMAP(convert,cgconvert);
  ADHOCMAP(drop,cgstmtstub);	-- NYI
  ADHOCMAP(every,cgevery);
  ADHOCMAP(exists,cgexists);
  ADHOCMAP(expression_block,cgexprblock);
  ADHOCMAP(extract,cgextract);
  ADHOCMAP(for_enumerate,cgforenum);
  ADHOCMAP(for_inspect,cgforinsp);
  ADHOCMAP(forall,cgforall);
  ADHOCMAP(if,cgif);
  ADHOCMAP(inspect_polymorph,cginsppoly);
  ADHOCMAP(inspect_table,cginsptbl);
  ADHOCMAP(named_literal,cgnamedlit);
  ADHOCMAP(new,cgnew);
  ADHOCMAP(position_of_element,cgposofelt);
  ADHOCMAP(position_of_selector,cgposition);
  ADHOCMAP(program_literal,cgproglit);
  ADHOCMAP(remove,cgremove);
  ADHOCMAP(select,cgselect);
  ADHOCMAP(the_element,cgtheelement);
  ADHOCMAP(while,cgwhile);
  -- wrap it up and store it away
  wrap map as poly;
  call init.std.WriteObj(charstring#"opmap.obj",poly);

  return init;
  
end process

