-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disoperation: using (predefined,interpform,disassembler,disinternal)
  process (Q: disoperationQ)
  declare
    args: disoperation;
    s: charstring;
    qual: charstring;
  begin
    receive args from Q;
    new s;
    -- first the opcode
    merge args.dis.opcode(args.operation.opcode)
       into s;
    insert char#' ' into s;
     -- then the operands
    for operand in args.operation.operands[]
      inspect
	merge args.dis.operand(args.dis,operand)
	   into s;
	insert char#' ' into s;
      end for;
    -- then the qualifier
    if (boolean#(qualifier_type#(case of args.operation.qualifier)
		   =qualifier_type#'absent'))
      then
	-- no qualifier, do nothing
      else
	qual <- args.dis.qualifier
	   (args.dis,args.operation.qualifier,args.operation.opcode);
	if (boolean#(exists of qual[]))
	  then
	    insert char#',' into s;
	    insert char#' ' into s;
	    merge qual into s;
	  else
	    -- empty qualifier => no representation
	  end if;
      end if;
    -- return the string
    -- print s;
    args.rep <- s;
    return args;
  on (disqualifier.Unsupported)
    return args exception Unsupported;
  end process
