-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disqualifier: using(predefined,interpform,disassembler,common,disinternal)
  process (Q: disqualifierQ)
  declare
    args: disqualifier;
    string: charstring;
  begin
    receive args from Q;
    -- print charstring#"Printing a qualifier.";
    -- print args.qualifier;
    new string;
    select qualifier_type#(case of args.qualifier)
      where (qualifier_type#'absent')
	-- empty string
      where (qualifier_type#'boolean')
	-- represent truth with "true", falsehood with "false"
	reveal args.qualifier.boolean;
	if (args.qualifier.boolean)
	  then
	    merge charstring#"true" into string at integer#(size of string);
	  else
	    merge charstring#"false" into string at integer#(size of string);
	  end if;
      where (qualifier_type#'integer')
	-- represent integers in signed decimal
	reveal args.qualifier.integer;
	block
	  declare
	    label: boolean;
	  begin
	    select (args.context)
	      where (opcode#'get_or_goto')
		label <- boolean#'true';
	      where (opcode#'idxfind_or_goto')
		label <- boolean#'true';
	      where (opcode#'branch')
		label <- boolean#'true';
	      where (opcode#'branch_false')
		label <- boolean#'true';
	      where (opcode#'branch_true')
		label <- boolean#'true';
	      otherwise
		label <- boolean#'false';
	      end select;
	    if (label)
	      then
		block begin
		    insert integer#(copy of args.qualifier.integer)
		       into args.dis.label.dests;
		  on (DuplicateKey)
		  end block;
		merge charstring#(copy of args.dis.label.label_base)
		   into string at integer#(size of string);
	      else
	      end if;
	    merge args.dis.integer(args.qualifier.integer) 
	       into string at integer#(size of string);
	  end block;
      where (qualifier_type#'real')
	print charstring#"real qualifiers are unsupported.";
	exit Unsupported;
      where (qualifier_type#'string')
	reveal args.qualifier.string;
	insert char#'"' into string at integer#(size of string);
	for c in args.qualifier.string[]
	  inspect
	    if (boolean#(c=char#'"'))
	      then
		insert char#'"' into string at integer#(size of string);
	      else
	      end if;
	    insert char#(copy of c) into string at integer#(size of string);
	  end for;
	insert char#'"' into string at integer#(size of string);
      where (qualifier_type#'integer_pair')
	reveal args.qualifier.integer_pair;
	-- string representation depends on context
	block
	  declare
	    temp: interpform!qualifier;
	    first: boolean;
	    second: boolean;
	  begin
	    select (args.context)
	      where (opcode#'oeloop')
		first <- boolean#'true';
		second <- boolean#'false';
	      where (opcode#'find_or_goto')
		first <- boolean#'false';
		second <- boolean#'true';
	      otherwise
		first <- boolean#'false';
		second <- boolean#'false';
	      end select;
	    merge charstring#"pair " into string;
	    if (first)
	      then
		-- the first element is really a label
		unite temp.integer 
		   from integer#(copy of args.qualifier.integer_pair.int_one);
		merge args.dis.qualifier(args.dis,temp,opcode#'branch') 
		   into string at integer#(size of string);
	      else
		merge args.dis.integer(args.qualifier.integer_pair.int_one)
		   into string at integer#(size of string);
	      end if;
	    insert char#' ' into string at integer#(size of string);
	    if (second)
	      then
		-- the second element is really a label
		unite temp.integer 
		   from integer#(copy of args.qualifier.integer_pair.int_two);
		merge args.dis.qualifier(args.dis,temp,opcode#'branch') 
		   into string at integer#(size of string);
	      else
		merge args.dis.integer(args.qualifier.integer_pair.int_two)
		   into string at integer#(size of string);
	      end if;
	  end block;
      where (qualifier_type#'polymorph_info')
	print charstring#"polymorph qualifiers are ignored.";
      where (qualifier_type#'program')
	-- There is no representation for program qualifiers in LI assembler.
	-- Their hidden code field gets written out at a code qualifier
	reveal args.qualifier.program;
	block
	  declare
	    temp: interpform!qualifier;
	    prog: interpform!prog;
	  begin
	    prog <- args.dis.unstuff(args.qualifier.program);
	    unite temp.code from prog;
	    merge args.dis.qualifier(args.dis,temp,opcode#'noop')
	       into string at integer#(size of string);
	  end block;
	
      where (qualifier_type#'code')
	reveal args.qualifier.code;
	-- represent an LI prog as text:
	block
	  declare
	    top: charstring;
	    code: source;
	    bottom: charstring;
	    total: charstring;
	    temp: interpform!qualifier;
	    name: charstring;
	    line: charstring;
	    blanks: charstring;
	    indentation: charstring;
	    dis: dis;
	    dests: dests;
	    max_digits: integer;
	    max_line: integer;
	    max_label: integer;
	    skip: integer;
	    count: integer;
	    label: charstring;
	    prog: interpform!prog;
	  begin
	    -- setup for call
	    -- the process's name
	    -- print charstring#"Translating a code qualifier";
	    new name;
	    for c in args.qualifier.code.name[] 
	      inspect
		select (c)
		  where (char#' ')
		  where (char#'(')
		  where (char#')')
		  where (char#'/')
		    name <- charstring#"D";
		  where (char#'.')
		    insert char#'_' into name at integer#(size of name);
		  otherwise
		    insert char#(copy of c)
		       into name at integer#(size of name);
		  end select;
	      end for;
	    -- print name;
	    -- print charstring#"Create a new dis structure";
	    new dis;
	    dis.pms := args.dis.pms;
	    dis.operation := args.dis.operation;
	    dis.opcode := args.dis.opcode;
	    dis.operand := args.dis.operand;
	    dis.qualifier := args.dis.qualifier;
	    dis.integer := args.dis.integer;
	    dis.blanks := args.dis.blanks;
	    dis.unstuff := args.dis.unstuff;
	    new dis.label;
	    dis.label.prog_name := name;
	    dis.label.line_base := charstring#"LI";
	    dis.label.label_base := name;
	    dis.label.exit_base := name;
	    merge charstring#"_exit" into dis.label.exit_base
	       at integer#(size of dis.label.exit_base);
	    dis.label.indentation <-
	       args.dis.label.indentation + args.dis.label.max_blanks;
	    -- determine the largest possible indentation
	    max_digits <- 
	       integer#(size of dis.integer
		   (integer#(size of args.qualifier.code.code)));
	    max_line <-
	       integer#(size of charstring#"/**/ ")+
	       integer#(size of dis.label.line_base)+
	       max_digits;
	    max_label <-
	       integer#(size of charstring#": ")+
	       integer#(size of dis.label.label_base)+
	       max_digits;
	    if (boolean#(max_line>max_label))
	      then
		dis.label.max_blanks <- max_line;
	      else
		dis.label.max_blanks <- max_label;
	      end if;
	    -- generate default indentation
	    indentation <- args.dis.blanks(dis.label.indentation);
	    blanks <- args.dis.blanks(dis.label.max_blanks);
	    -- these two fields are modified during the disassembly
	    new dis.label.exits;
	    new dis.label.dests;
	    -- create prog info
	    -- print charstring#"Create info at the top";
	    new top;
	    merge charstring#"process " into top;
	    merge charstring#(copy of name) into top;
	    insert char#' ' into top;
	    unite temp.typename 
	       from typename#(copy of args.qualifier.code.type);
	    merge args.dis.qualifier(dis,temp,opcode#'noop') into top;
	    insert char#' ' into top;
	    merge args.dis.integer(args.qualifier.code.size) into top;
	    insert char#'NL' into top;
	    merge args.dis.blanks(dis.label.indentation+dis.label.max_blanks)
	       into top;
	    merge charstring#"linking ( " into top;
	    for absprog in args.qualifier.code.linkedProgs[]
	      inspect
		prog <- dis.unstuff(absprog);
		merge charstring#(copy of prog.name) into top;
		insert char#' ' into top;
	      end for;
	    insert char#')' into top;
	    -- generate the actual code
	    -- print charstring#"Call dis.operation for each LI instruction";
	    new code;
	    -- convert the instructions into code
	    for operation in args.qualifier.code.code[]
	      inspect
		insert args.dis.operation(dis,operation)
		   into code at integer#(position of operation);
	      end for;
	    -- generate the bottom
	    bottom <- charstring#"end";
	    -- combine the instructions into one text string
	    -- print charstring#"Combine the instructions into one string";
	    new total;
	    -- combine the top,
	    merge top into total at integer#(size of total);
	    insert char#'NL' into total at integer#(size of total);
	    -- the code,
	    dests <- dis.label.dests;
	    new dis.label.dests;
	    count <- integer#0;
	    skip <- integer#0;
	    while (boolean#(integer#(size of code)>integer#0))
	      repeat
		remove line from code[integer#0];
		-- If line should be labeled, label it.
		if (boolean#(exists of dests[count]))
		  then
		    -- put in a label
		    new label;
		    unite temp.integer from integer#(copy of count);
		    merge args.dis.qualifier(dis,temp,opcode#'branch') 
		       into label at integer#(size of label);
		    merge charstring#":" into label 
		       at integer#(size of label);
		    merge args.dis.blanks(integer#
			   (dis.label.max_blanks-integer#(size of label)))
		       into label at integer#(size of label);
		  else
		    if (boolean#(skip=integer#0))
		      then
			-- mark the line
			new label;
			unite temp.integer from integer#(copy of count);
			merge charstring#"/*" into label 
			   at integer#(size of label);
			merge charstring#(copy of dis.label.line_base)
			   into label at integer#(size of label);
			merge args.dis.qualifier(dis,temp,opcode#'noop') 
			   into label at integer#(size of label);
			merge charstring#"*/" into label 
			   at integer#(size of label);
			merge args.dis.blanks(integer#
			       (dis.label.max_blanks-integer#(size of label)))
			   into label at integer#(size of label);
		      else
			-- just put in blanks
			label := blanks;
		      end if;
		  end if;
		merge charstring#(copy of indentation)
		   into total at integer#(size of total);
		merge label into total at integer#(size of total);
		merge line into total at integer#(size of total);
		insert char#'NL' into total at integer#(size of total);
		if (boolean#(skip<=integer#0))
		  then
		    skip <- integer#4;
		  else
		    skip <- integer#(skip-integer#1);
		  end if;
		count <- integer#(count+integer#1);
	      end while;
	    -- and the bottom
	    merge charstring#(copy of indentation)
	       into total at integer#(size of total);
	    merge bottom into total at integer#(size of total);
	    -- return the whole schmeer
	    merge total into string at integer#(size of string);
	  end block;

      where (qualifier_type#'exception')
	reveal args.qualifier.exception;
	-- first part on the exception is a typename
	if (boolean#(args.context=opcode#'noop'))
	  then
	  else
	    merge charstring#"exception " 
	       into string at integer#(size of string);
	  end if;
	block
	  declare
	    temp: interpform!qualifier;
	  begin
	    unite temp.typename 
	       from typename#(copy of args.qualifier.exception.type);
	    merge args.dis.qualifier(args.dis,temp,opcode#'noop')
	       into string at integer#(size of string);
	    insert char#'.' into string at integer#(size of string);
	    inspect module 
		in args.dis.pms.defs
		   [args.qualifier.exception.type.moduleid]
	      begin
		inspect exception 
		    in module.exceptions 
		       where (boolean#(
			    boolean#(exception.type 
				   = args.qualifier.exception.type.typeid)
			       and
			       boolean#(exception.exception
				   = args.qualifier.exception.exceptionid)
			  ))
		  begin
		    merge charstring#(copy of exception.name) into string
		       at integer#(size of string);
		  end inspect;
	      end inspect;
	  on (NotFound)
	    print charstring#"Exception not found.";
	  end block;
      where (qualifier_type#'typename')
	if (boolean#(not boolean#(args.context=opcode#'noop')))
	  then
	    merge charstring#"typeid " into string 
	       at integer#(size of string);
	  else
	  end if;
	reveal args.qualifier.typename;
	block
	  begin
	    inspect module 
		in args.dis.pms.defs[args.qualifier.typename.moduleid]
	      begin
		merge charstring#(copy of module.name) into string
		   at integer#(size of string);
		insert char#'!' into string at integer#(size of string);
		inspect type in module.types
		       where (boolean#(type.id=args.qualifier.typename.typeid))
		  begin
		    merge charstring#(copy of type.name) into string
		       at integer#(size of string);
		  end inspect;
	      end inspect;
	  on (NotFound)
	    print charstring#"Typename not found.";
	  end block;
      where (qualifier_type#'block')
	-- handler list
	reveal args.qualifier.block;
	block
	  declare
	    first: boolean;
	  begin
	    merge charstring#"handlers " into string
	       at integer#(size of string);
	    first <- boolean#'true';
	    for handler in args.qualifier.block[] 
	      inspect
		if (first)
		  then
		    first <- boolean#'false';
		  else
		    insert char#' ' into string at integer#(size of string);
		    insert char#',' into string at integer#(size of string);
		  end if;
		block
		  declare
		    temp: interpform!qualifier;
		    s: charstring;
		  begin
		    select handler_type#(case of handler.handler)
		      where (handler_type#'builtin')
			reveal handler.handler.builtin;
			select (handler.handler.builtin)
			  where(builtin_exception#'CaseError')
			    s <- charstring#"CaseError";
			  where(builtin_exception#'ConstraintError')
			    s <- charstring#"ConstraintError";
			  where(builtin_exception#'ConstraintFailure')
			    s <- charstring#"ConstraintFailure";
			  where(builtin_exception#'Depletion')
			    s <- charstring#"Depletion";
			  where(builtin_exception#'Disconnected')
			    s <- charstring#"Disconnected";
			  where(builtin_exception#'DivideByZero')
			    s <- charstring#"DivideByZero";
			  where(builtin_exception#'DuplicateKey')
			    s <- charstring#"DuplicateKey";
			  where(builtin_exception#'InterfaceMismatch')
			    s <- charstring#"InterfaceMismatch";
			  where(builtin_exception#'NotFound')
			    s <- charstring#"NotFound";
			  where(builtin_exception#'PolymorphMismatch')
			    s <- charstring#"PolymorphMismatch";
			  where(builtin_exception#'DefinitionError')
			    s <- charstring#"DefinitionError";
			  where(builtin_exception#'RangeError')
			    s <- charstring#"RangeError";
			  where(builtin_exception#'Uncopyable')
			    s <- charstring#"Uncopyable";
			  otherwise
			    print charstring#"Unknown builtin exception";
			    exit Unsupported;
			  end select;
		      where (handler_type#'user')
			reveal handler.handler.user;
			unite temp.exception 
			   from user_exception#(copy of handler.handler.user);
			s <- args.dis.qualifier(args.dis,temp,opcode#'noop');
		      where (handler_type#'exit')
			reveal handler.handler.exit;
			unite temp.exit 
			   from exitid#(copy of handler.handler.exit);
			s <- args.dis.qualifier(args.dis,temp,opcode#'branch');
		      where (handler_type#'others')
			reveal handler.handler.others;
			s <- charstring#"others";
		      otherwise
			s <- "Unknown exception";
		      end select;
		    merge s into string at integer#(size of string);
		    insert char#' ' into string at integer#(size of string);
		    unite temp.integer from integer#(copy of handler.label);
		    merge args.dis.qualifier(args.dis,temp,opcode#'branch') 
		       into string at integer#(size of string);
		  end block;
	      end for;
	    insert char#';' into string at integer#(size of string);
	  end block;
      where (qualifier_type#'exit')
	reveal args.qualifier.exit;
	merge charstring#"exitid " into string
	   at integer#(size of string);
	block begin
	    inspect module 
		in args.dis.pms.execs[args.dis.pms.progid]
	      begin
		inspect exitmap
		    in module.exits
		       where (boolean#(args.qualifier.exit=exitmap.exit))
		  begin
		    merge charstring#(copy of exitmap.name)
		       into string at integer#(size of string);
		  end inspect;
	      end inspect;
	  on (NotFound)
	    print charstring#"Exit not found.";
	    block
	      declare
		rec: exit_printrec;
		name: charstring;
	      begin
		inspect exitmap in args.dis.label.exits 
		       where (boolean#(args.qualifier.exit=exitmap.exit))
		  begin 
		    name := exitmap.name;
		    merge name into string at integer#(size of string);
		  end inspect;
	      on (NotFound)
		new rec;
		rec.exit := args.qualifier.exit;
		name := args.dis.label.label_base;
		merge charstring#"_exit" into name at integer#(size of name);
		merge 
		   args.dis.integer(integer#(size of args.dis.label.exits))
		   into name at integer#(size of name);
		rec.name := name;
		insert rec into args.dis.label.exits;
		merge name into string at integer#(size of string);
	      end block;
	  end block;
      where (qualifier_type#'select')
	reveal args.qualifier.select;
	-- print out a ' ' seperated list of labels
	merge charstring#"selectarms " into string at integer#(size of string);
	block
	  declare
	    temp: interpform!qualifier;
	  begin
	    for label in args.qualifier.select[]
	      inspect
		unite temp.integer from integer#(copy of label);
		merge args.dis.qualifier(args.dis,temp,opcode#'branch') 
		   into string at integer#(size of string);
		insert char#' ' into string at integer#(size of string);
	      end for;
	  end block;
	insert char#';' into string at integer#(size of string);
      where (qualifier_type#'new_table')
	reveal args.qualifier.new_table;
	block
	  declare
	    temp: interpform!qualifier;
	    first: boolean;
	  begin
	    merge charstring#"table " into string
	       at integer#(size of string);
	    -- optional primary representation
	    select table_rep_type#(case of args.qualifier.new_table.nonlookup)
	      where (table_rep_type#'none')
	      where (table_rep_type#'vector')
		merge args.dis.integer(1)
		   --(convert of (case of args.qualifier.new_table.nonlookup))
		   into string at integer#(size of string);
		insert char#' ' into string at integer#(size of string);
	      where (table_rep_type#'charstring')
		merge args.dis.integer(2)
		   --(convert of (case of args.qualifier.new_table.nonlookup))
		   into string at integer#(size of string);
		insert char#' ' into string at integer#(size of string);
	      where (table_rep_type#'linklist')
		merge args.dis.integer(9)
		   --(convert of (case of args.qualifier.new_table.nonlookup))
		   into string at integer#(size of string);
		insert char#' ' into string at integer#(size of string);
	      otherwise
		print charstring#"Unknown primary rep. in new_table_info.";
		exit Unsupported;
	      end select;
	    -- optional lookup_info
	    if (boolean#(option#(case of args.qualifier.new_table.opt_reps)
			   =option#'present'))
	      then
		reveal args.qualifier.new_table.opt_reps.info;
		-- first list: reps
		first <- boolean#'true';
		insert char#'(' into string at integer#(size of string);
		for rep in args.qualifier.new_table.opt_reps.info.reps[]
		  inspect
		    if (first)
		      then
			first <- boolean#'false';
		      else
			insert char#',' into string 
			   at integer#(size of string);
		      end if;
		    merge args.dis.integer (
			evaluate number:integer from
			    select (case of rep)
			      where ('none')
				number <- 0;
			      where ('vector')
				number <- 1;
			      where ('charstring')
				number <- 2;
			      where ('dublink')
				number <- 3;
			      where ('keyavl')
				number <- 4;
			      where ('keyhash')
				number <- 5;
			      where ('bitset')
				number <- 6;
			      where ('indexavl')
				number <- 7;
			      where ('indexhash')
				number <- 8;
			      where ('linklist')
				number <- 9;
			      otherwise
				print charstring#"Unknown table_rep_type.";
				exit Unsupported;
			      end select;
			  end
		      )
		       --(convert of (case of rep))
		       into string at integer#(size of string);
		  end for;
		insert char#')' into string at integer#(size of string);
		insert char#' ' into string at integer#(size of string);
		-- second list: keys
		insert char#'(' into string at integer#(size of string);
		first := boolean#'true';
		for key in args.qualifier.new_table.opt_reps.info.keys[]
		  inspect
		    if (first)
		      then
			first := boolean#'false';
		      else
			insert char#',' into string 
			   at integer#(size of string);
		      end if;
		    for op in key[]
		      inspect
			merge args.dis.operand(args.dis,op)
			   into string at integer#(size of string);
			insert char#' ' into string 
			   at integer#(size of string);
		      end for;
		  end for;
		insert char#')' into string at integer#(size of string);
		insert char#' ' into string at integer#(size of string);
		-- third list: indices
		insert char#'(' into string at integer#(size of string);
		first := boolean#'true';
		for indice in args.qualifier.new_table.opt_reps.info.indices[]
		  inspect
		    if (first)
		      then
			first := boolean#'false';
		      else
			insert char#',' into string 
			   at integer#(size of string);
		      end if;
		    for op in indice[]
		      inspect
			merge args.dis.operand(args.dis,op)
			   into string at integer#(size of string);
			insert char#' ' into string 
			   at integer#(size of string);
		      end for;
		  end for;
		insert char#')' into string at integer#(size of string);
	      else
	      end if;
	  end block;
      where (qualifier_type#'attributename')
	print charstring#"attributename qualifiers are unsupported.";
	exit Unsupported;
      otherwise
	print charstring#"unknown qualifier sent to disqualifier.";
	exit Unsupported;
      end select;
    -- print string;
    args.rep <- string;
    return args;
  on exit (Unsupported)
    return args exception Unsupported;
  on (disqualifier.Unsupported,disoperation.Unsupported,disopcode.Unsupported)
    return args exception Unsupported;
  end process
