-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtobject.p	1.3 3/13/90

FmtObject : USING(AbsFormat, InferredType)
PROCESS (FormatObjectInit : FormatObjectInport )
-- procedure to format an object
-- algorithm:  format the rootname
--             if there are components, format a dot followed by the components
  DECLARE
    FP: FormatObjectCall ;
    RootType: Typename; -- type of root, needed to Format components
    ComponentNames: Charstring;
  BEGIN
    RECEIVE FP FROM FormatObjectInit;
    CALL FP.Formatters.FormatRoot(FP.Formatters, FP.Declarations, FP.InferredDeclarations, FP.Definitions, FP.DefinitionsMap, FP.ExecutableMap, FP.Object.Root, RootType,  FP.FormatValue);
    CALL FP.Formatters.FormatComponents(FP.Formatters, FP.Definitions, FP.DefinitionsMap, FP.Object.Components, RootType,  ComponentNames);
    IF SIZE OF ComponentNames = 0
      THEN
      ELSE
        INSERT '.' INTO FP.Formatvalue;
        MERGE COPY OF ComponentNames INTO FP.Formatvalue;
      END IF;
    RETURN FP;
  END PROCESS
