-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtroot.p	1.5 3/13/90

FmtRoot : USING(AbsFormat, InferredType)
PROCESS (FormatRootInit : FormatRootInport )
  DECLARE
    FP: FormatRootCall ;
  BEGIN
    RECEIVE FP FROM FormatRootInit;
    INSPECT RootScope IN FP.Declarations WHERE(boolean #(FP.Root.Scope = Rootscope.Id))
      BEGIN
        BLOCK
          BEGIN
	    INSPECT RootMap IN FP.ExecutableMap.Roots WHERE(boolean #(boolean #(RootMap.Scope = FP.Root.Scope) AND boolean #(RootMap.Root = FP.Root.Root)))
	      BEGIN
		FP.Formatvalue := RootMap.Name;
	      END INSPECT;
	  ON (NotFound)
	    FP.Formatvalue := "*Temporary*";
          END BLOCK;
        BLOCK
          BEGIN
            INSPECT Declaration IN RootScope.Declarations WHERE(boolean #(Declaration.Id = FP.Root.Root))
              BEGIN
                REVEAL Declaration.Typename.Typename;
                FP.Type := Declaration.Typename.Typename;
              END INSPECT;
          ON (CaseError)
            block begin
            INSPECT Declaration IN FP.InferredDeclarations WHERE(boolean #(Declaration.Root = FP.Root))
              BEGIN
                FP.Type := Declaration.Type;
              END INSPECT;
 	    on (notfound)  
	      -- Couldn't find the type... make one up to satisfy typestate
	      new FP.Type;
	      FP.Type.ModuleId <- unique;
	      Fp.Type.Typeid <- unique;
	    end block;
	  ON (NotFound)
	    -- another case where type couldn't be found
	    new FP.Type;
	    FP.Type.ModuleId <- unique;
	    FP.Type.Typeid <- unique;
          END BLOCK;
      END INSPECT;
    RETURN FP;
  ON (NotFound)
    -- Couldn't find the right scope
    FP.FormatValue := "??";
    new FP.Type;
    FP.Type.ModuleId <- unique;
    FP.Type.TypeId <- unique;
    return FP;

  END PROCESS

