-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: fixdefs.p
-- Author: Rob Strom
-- SCCS Info: @(#)fixdefs.p	1.7 3/13/90

-- Main Program to post-process a definitions module
-- getting rid of all the uses of FULL and expanding them to INIT
-- filling in minimum formal typestate for callmessages

fixdefs: using (common, main, filedef, parse,
  inferredtype, interpform,  
  objectIO, fixdefs, checkDefs, errors)
  process ( initport: main_q )

declare
  init: main_intf;
  junk: charstring;
  empty: empty; -- empty type
  filename: charstring; -- of old/new definition
  filename2: charstring; -- of imported definitions
  arbobj: polymorph;
  badModule: charstring;
  defMaps: definitions_printmappings;
  procMaps: executable_printmappings;
  poly: polymorph;
  Nothing: empty;
  definitions: definitions_modules; -- all the definitions modules
  filedef: filed_definition; -- definition being loaded
  ToBeFixed: filed_definition;  -- the definition to be fixed
  imports: module_printmap; -- the definitions needed by the module being loaded
  imported: module_printmap; -- the definitions we have already loaded
  neededModule: module_printrec; -- the description of a module we need to import
  checkdefs: checkdefsFn;
  errors: errors;
  fix: FixdefsOutport; -- program to do fix


begin 
  receive init from initport;

-- Load the code for fixdefsint
  fix <- PROCEDURE OF Init.Std.PathLoad("fixdefsint");
  checkdefs := procedure of init.std.pathLoad("checkdefs");
  
-- Main loop: process each definition
-- 1. build an empty list of definitions
-- 2. read the definition to be fixed
-- 4. insert it into the full definitions list
-- 5. insert its dependencies into the needed module list
-- 6. drag in dependent modules until none needed
-- 7. fix the definition
-- 10. write the fixed definition out
  for string in init.argv where (position of string > 1) inspect
  
  block begin
  call init.std.terminal.putString(string | ":");
  
  -- 1.
  new definitions;
  new defMaps;
  -- 2.
  filename := string | ".do";
  BLOCK
    BEGIN
      call init.std.terminal.putstring(" load[" | filename | "]");
      arbobj <- polymorph#(Init.Std.pathReadObj(filename));
      unwrap ToBeFixed from arbobj { init, init(definitions_module), init(defmap), init(procmaps), init(direct_imports), init(definitions_module.id), init(definitions_module.type_definitions), init(definitions_module.attr_definitions), init(defmap.id), init(defmap.name), init(defmap.types), init(defmap.attributes), init(defmap.components), init(defmap.exceptions) };
    ON (ReadObject_Intf.File_Not_Found)
          call init.std.terminal.putLine(" ERRORS");
          call Init.Std.terminal.putString(charstring#"Definitions module '");
          call Init.Std.terminal.putString(string);
          call Init.Std.terminal.putLine(charstring#"' not found.");
      EXIT PrematureTermination;
    END BLOCK;
  -- 4. 
  insert copy of ToBeFixed.definitions_module into definitions;
  insert copy of ToBeFixed.defmap into defMaps;
  -- 5. 
  imports := ToBeFixed.Direct_Imports;
  new imported;
  REMOVE NeededModule FROM M IN imports WHERE(M.Name = string);
  INSERT NeededModule INTO imported;
  -- 6. 
  while boolean#(integer#(size of imports) <> integer#0) repeat
    block begin
      -- get the name of a module which needs to be imported
      remove NeededModule from map in imports where (boolean#'true');

      -- read the definition from disk
      filename2 <- charstring#(NeededModule.name | charstring#".do");
      arbobj <- polymorph#(Init.Std.pathReadObj(filename2));
      unwrap filedef from arbobj { init, init(definitions_module), init(defmap), init(procmaps), init(direct_imports), init(definitions_module.id), init(definitions_module.type_definitions), init(definitions_module.attr_definitions), init(defmap.id), init(defmap.name), init(defmap.types), init(defmap.attributes), init(defmap.components), init(defmap.exceptions) };

      -- verify that the moduleid on disk matches the moduleid expected
      if boolean #(filedef.definitions_module.id <> NeededModule.id) 
        then
          call Init.Std.terminal.putString(charstring#"Definitions module '");
          call Init.Std.terminal.putString(NeededModule.Name);
          call Init.Std.terminal.putLine(charstring#"' is inconsistent with disk.");
          EXIT PrematureTermination;
        end if;

      -- append the definitions module and definitions printmap
      insert filedef.definitions_module into definitions;
      insert filedef.defmap into defMaps;

      -- put the module name into the set of modules imported
      insert NeededModule into imported;	-- remember that we imported this one
      
      -- for each module imported by the definition:
      -- if it hasn't been imported yet, add it to the list of needed imports
      -- if it has been imported already, verify that the expected moduleid matches the loaded moduleid
      for map in filedef.direct_imports where (boolean#'true') inspect 
	block begin
	  inspect ImportedModule IN Imported WHERE(boolean # (ImportedModule.Name = Map.Name))
	    BEGIN
	      IF boolean #(ImportedModule.Id <> Map.Id)
	        THEN
                  call Init.Std.terminal.putString(charstring#"Definitions module '");
                  call Init.Std.terminal.putString(ImportedModule.Name);
                  call Init.Std.terminal.putLine(charstring#" is inconsistent.");
		  EXIT PrematureTermination;
	        END IF;
	    END INSPECT;
	on (NotFound)
	  BLOCK
	    BEGIN
	      insert module_printrec#(copy of map) into imports;
	    ON (DuplicateKey)
	    END BLOCK;
	end block;
      end for;

      discard filedef.direct_imports;

    on (readobject_intf.file_not_found)  
      call Init.Std.terminal.putString(charstring#"Definitions module '");
      call Init.Std.terminal.putString(NeededModule.Name);
      call Init.Std.terminal.putLine(charstring#"' was not found.");
      EXIT PrematureTermination;
    end block;
  end while;
  
  -- run checkdefs on it
  call init.std.terminal.putString(" checkdefs");
  call checkdefs(ToBeFixed.definitions_module.id, definitions, errors);
  if size of errors <> 0 then
      call init.std.terminal.putLine(" ERRORS - run dcom for details");
      exit PrematureTermination;
    end if;


  call init.std.terminal.putString(" fixdefs");
  call fix(Init.Std, ToBeFixed, definitions);

  
  --10.
  call init.std.terminal.putString(" store[" | filename | "]");
  wrap ToBeFixed as arbobj;
  call Init.Std.writeObj(filename, arbobj);
  
----------- Done
  call init.std.terminal.putLine("");

  on exit(PrematureTermination)
  end block;

  end for;

  return init;

end process
