-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)pathload.p	1.3 3/13/90

pathload: using (predefined, unix, load, findfile, pathload) 
  process (initport: pathload_init_q)

declare
  init: pathload!pathload_init_intf;
  pathfinder: findfile_func;
  loader: load_func;
  loadq: load_q;
  request: load_intf;
  filename: charstring;

begin
  receive init from initport;		-- initialization
  pathfinder := init.pathfinder;
  loader := init.loader;
  new loadq;
  connect init.pathloader to loadq;
  return init;
  discard initport;

  while boolean#'true' repeat		-- service loop
    block begin
      receive request from loadq;
      filename <- charstring#(request.modulename | charstring#".po");
      request.program <-
	program#(loader(charstring#(pathfinder(filename, access#'read'))));
      return request;

    on (load_intf.file_not_found, findfile_intf.file_not_found)
      return request exception file_not_found;
    end block;
  end while;
end process
