/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)cherm.h	1.4 3/13/90 */

#ifndef cherm_included

#include "li.h"

#include "../cherm/declare_o.h"
#include "../cherm/datarep.h"
#include "../cherm/hcalls.h"

#define Component 0
				/* the component of a variant */
#define Id        0
				/* by convention, id keys are component 0 */

#define PRIMARY_KEY 0
#define SECONDARY_KEY 0

#define BEGIN_CHERM (cherm_flag = TRUE)
#define END_CHERM (cherm_flag = FALSE)


#define set_bottom(obj)	     ((obj)->tsdr = &dr_bottom)
#define cheapcopy(dst,src)   (*(dst) = *(src))
#define avl_baltree(objp)    (&(objp)->value.avl_table->treeset[0])
#define size_of(objp)        ((objp)->value.table->size)
#define case_of(objp)        ((objp)->value.variant->info.variant_case)
#define vec_elements(objp)   ((objp)->value.table->tbls[0].rep.vec->elements)
#define integerval(objp)     ((objp)->value.integer)
#define booleanval(objp)     ((objp)->value.boolean)
#define enumval(objp)        ((objp)->value.enumeration)

#ifndef ISCHERM

extern objectp Bottom;

extern object
  *whole_key,			/* keys (*) */
  *firstelem_key,		/* keys (f1) */
  *secondelem_key,		/* keys (f2) */
  *firstandthird_key,		/* keys (f1,f2) */
  *firstandsecond_keyset,	/* keys (f1) (f2) */
  *epmap_keyset;		/* keys (f1,f2) (f1,f3) */

#endif

status vec_new_table();
status bag_new_table();
status chs_new_table();
status avl_new_table();
status avl2_new_table();
status chs_lit();

objectp new_object();
void free_object();

predef_exception h_call(), h_qcall(), h_scall();

predef_exception h_lookup();
predef_exception h_lookup_secondary();


#define dot(obj,comp) (&(obj->value.record->data[comp]))

/* we stuff parms into a qualholder before passing them because C gets very
   confused when union components are passed as parameters */

typedef struct
{
    valcell val;

} qualholder;

#ifndef ISCHERM
extern qualholder _qh;
#endif

#endif
#define cherm_included
