-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: formaterror.d
-- Author: Andy Lowry
-- SCCS Info: @(#)formaterror.d	1.2 3/13/90

formatError: using (errors, absFormat, common, inferredtype, posmap)
definitions
    
  -- procedure to format a single compiler error message
  formatError: callmessage (
    error: error,
    -- compilation context
    decls: scopes,
    infDecls: inferredDefinitions,
    defs: definitions_modules,
    defMap: definitions_printMappings,
    procMap: executable_printmap,
    positions: posMaps,
    -- formatted error message
    errMsg: charstring
  )
  constant
      (error, decls, infDecls, defs, defMap, procMap, positions)
  exit {full};
  formatErrorQ: inport of formatError {
    full(error), full(decls), full(infDecls), full(defs),
    full(defMap), full(procMap), full(positions) };
  formatErrorFn: outport of formatErrorQ;

end definitions

