-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: initparse.d
-- Author: David F. Bacon
-- SCCS Info: @(#)initparse.d	1.3 3/13/90

initParse: using (parse, load, objectIO, cwd) definitions

  parseFns: record (
    load: load_func,		-- pathload 
    store: storeFunc,		-- libstore
    readObj: readobject_func,	-- pathread
    writeObj: writeobject_func,	-- libwrite
    getCwd: getCwdFn		-- getCwd
  );


  initParseDef: callmessage (
    fns: parseFns,
    parseDef: parseDefFn    
  ) constant (fns)
    exit { full };

  initParseDefQ: inport of initParseDef { full(fns) };
  initParseDefFn: outport of initParseDefQ;


  initParseProc: callmessage (
    fns: parseFns,
    parseProc: parseProcFn    
  ) constant (fns)
    exit { full };

  initParseProcQ: inport of initParseProc { full(fns) };
  initParseProcFn: outport of initParseProcQ;

end definitions
