-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: initloadfuncs.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)initloadfuncs.p	1.2 3/13/90"
-- description:
-- initFindfileFuncs is given some capabilities and returns 4 findfile
--  functions; they locate a return a file relative to a unix path.  
initloadfuncs: using(initloadfuncs,root,initfindfile,findfile)
process(q: initloadfuncsQ)

declare
  cm: initloadfuncsIntf; 
  findfile: findfile!findfile_func;
  enventry: root!enventry;
  path: charstring;    -- a charstring representing a unix path
  initFindFile: initfindfile!initFindFileFn;
begin

  receive cm from q;
  initFindFile <- procedure of cm.pathload("findfile");
  block begin
    enventry <- var in cm.environ where (var.variable = "HPATH");
    path <- enventry.value;
    findfile <- initFindFile(cm.access,cm.getCwd,path);
  on (NotFound)
    path <- ".:/homes/lusitania/hermes/bin" ;
    findfile <- initFindFile(cm.access,cm.getCwd,path);
  end block;

  cm.findfilePO := findFile;
  cm.findfileDO := findFile;
  cm.findfilePsrc := findFile;
  cm.findfileDsrc := findFile;
  return cm;
end process
