-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: makehermes.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)makehermes.p	1.4 3/23/90"
-- description:
-- this is the interface to the hermes make facility.  it is invoked by the 
-- command:
-- ``hermi makehermes <rootname>''
-- where <rootname> is the name of the root file (directory) to be 'made'.  It
-- is assumed that if rootname is not in the current directory, its path 
-- is given.  
makehermes: using(main,common,make,getdep)
process (initQ: main_q)

declare
  initM: main_intf;
  make: MakeFunc;
  setupGetdep: setupGetDepService;
  getDependencies: getDependenciesFunc;
  graph: dependencyGraph;
  root: make!charstringSet;
  argv: common!charstringList;
  argv1: charstring;
  modname: charstring;

  options: common!charstringList;
  actionType: actionType;
  actionControl: actionControl;
  errorControl: errorControl;
begin
   receive initM from initQ;

-- initialize defaults
   actionControl <- 'Inconsistent';
   errorControl <- 'Continue Other Paths';  
   actionType <- 'compile';
   argv := initM.argv;          -- copy the parameters
   block begin 
     remove argv1 from argv[0];   -- get rid of "hermi"
     remove argv1 from argv[0];   -- get rid of "makehermes"
     -- extract options if they exist
     extract options from word in argv where(word[0] = '-');
     for opt in options where('true')
     inspect
       for char in opt where(position of char > 0)  -- not the '-' char
       inspect
          select char
            where('n')  actionControl <- 'None';
            where('i')  actionControl <- 'Inconsistent';
            where('a')  actionControl <- 'All';
            where('s')  errorControl <- 'Stop';
            where('g')  errorControl <- 'Ignore';
            where('o')  errorControl <- 'Continue Other Paths';
	    where('p')  actionType <- 'print';
            where('c')  actionType <- 'compile';
            otherwise  exit inputError; -- abort
          end select;
       end for;
     end for;
-- the remaining arguments must be the modules to make
     new root;
     while size of argv > 0 repeat
       remove modname from argv[0];   
       insert modname into root;
     end while; 
   on (notfound)
     exit inputError;
   end block;

-- load the getdependencies function
   setupGetdep <- create of initM.std.pathload("getdep");
   getDependencies <- setupGetdep(initM.environ, initM.std, initM.unix, 
                         initM.CLoader, actionType);
   block begin
-- finally, load and call make
      make <- procedure of initM.std.pathload("make");
      graph <- make(root,actionControl,errorControl,getDependencies);
   on (MakeIntf.NotMade)
      call initM.std.terminal.putline("Make not complete. Error code 1.");
   on (MakeIntf.Circular)
      call initM.std.terminal.putline("Circularity detected. Error code 2.");
   end block;

   return initM;  

 on exit (inputError)
      call initM.std.terminal.putline("Incorrect input format. Error code 3.");
 on (others)
      print charstring#"unexpected exception raised in makehermes";

end process


