-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: userrm.d
-- Author: Andy Lowry
-- SCCS Info: @(#)userrm.d	1.2 3/13/90

-- Interface for a filter that sits between user-level applications
-- programs and the system resource manager.  The filter adds the
-- logged-in user name to every request sent to the resource manager.
-- The user application would not normally be given any capability to
-- alter this behavior.

userRM: using (rManager, sysRManager)
definitions
  
  -- Pass a user name and capabilities to the system resource manager,
  -- and get back a filtered resource manager for the given user
  userRM: callmessage (
    userName: charString,
    sysRM: sysRManager,
    rm: rManager
  )
  constant (userName, sysRM)
  exit {full};

  userRMQ: inport of userRM {init(userName), init(sysRM)};
  userRMFn: outport of userRMQ;
  
end definitions
