-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)assign.p	1.2 3/13/90 
-- This file contains Assign, the 'master' function that calls the 
-- the type assignment functions:
-- 'predefinedprogram'
-- 'predefineddefinitionsmodule'
-- 'predefineddefinitionsmodules'
-- 'predefinedboolean'
-- 'predefinedtypeofvalue'
-- 'predefinedtypestateofvalue'
-- 'predefinedinteger'
-- 'predefinedtypename'
-- 'predefinedattribute_name'

-- The type assignment functions have signature: definitions -> typename.  

assign: USING(predefined, assign) 
PROCESS(SetupQ: SetupAssignQueue) 

DECLARE
    SetupM: SetupAssignMessage;
    AssignM: AssignMessage;
    AssignQ: AssignQueue;
    AssignC: AssignCapa;
    predefinedprogram: AssignCapa;
    predefineddefinitionsmodule: AssignCapa;
    predefineddefinitionsmodules: AssignCapa;
    predefinedboolean: AssignCapa;
    predefinedtypeofvalue: AssignCapa;
    predefinedtypestateofvalue: AssignCapa;
    predefinedinteger: AssignCapa;
    predefinedtypename: AssignCapa;
    predefinedattribute_name: AssignCapa;

BEGIN
    NEW AssignQ;
    CONNECT AssignC TO AssignQ;

    RECEIVE SetupM FROM SetupQ;

    predefinedprogram <- PROCEDURE OF SetupM.load("predefinedprogram");
    predefineddefinitionsmodule <- PROCEDURE OF SetupM.load("predefineddefinitionsmodule");
    predefineddefinitionsmodules <- PROCEDURE OF SetupM.load("predefineddefinitionsmodules");
    predefinedboolean <- PROCEDURE OF SetupM.load("predefinedboolean");
    predefinedtypeofvalue <- PROCEDURE OF SetupM.load("predefinedtypeofvalue");
    predefinedtypestateofvalue <- PROCEDURE OF SetupM.load("predefinedtypestateofvalue");
    predefinedinteger <- PROCEDURE OF SetupM.load("predefinedinteger");
    predefinedtypename <- PROCEDURE OF SetupM.load("predefinedtypename");
    predefinedattribute_name <- PROCEDURE OF SetupM.load("predefinedattribute_name");

    -- provide an output port capacity to calling environment
    SetupM.assign_func <- AssignC;  
    RETURN SetupM;
    
    WHILE 'true'  -- forever process messages
    REPEAT
        RECEIVE AssignM FROM AssignQ;

-- forward the call message to the appropriate function to process
        SELECT 
    	    WHERE(AssignM.function = 'predefinedprogram')
    	    	SEND AssignM TO predefinedprogram;
            WHERE(AssignM.function = 'predefineddefinitionsmodule')
    	        SEND AssignM TO predefineddefinitionsmodule;
            WHERE(AssignM.function = 'predefineddefinitionsmodules')
    	    	SEND AssignM TO predefineddefinitionsmodules;
            WHERE(AssignM.function = 'predefinedboolean')
    	    	SEND AssignM TO predefinedboolean;
            WHERE(AssignM.function = 'predefinedtypeofvalue')
    	    	SEND AssignM TO predefinedtypeofvalue;
    	    WHERE(AssignM.function = 'predefinedtypestateofvalue')
    	    	SEND AssignM TO predefinedtypestateofvalue;
            WHERE(AssignM.function = 'predefinedinteger')
    	    	SEND AssignM TO predefinedinteger;
            WHERE(AssignM.function = 'predefinedtypename')
    	    	SEND AssignM TO predefinedtypename;
            WHERE(AssignM.function = 'predefinedattribute_name')
    	    	SEND AssignM TO predefinedattribute_name;
    	    OTHERWISE
    	END SELECT;  
    END WHILE;
END process

