-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)assign.p	1.3 3/13/90 

-- This file contains Assign, the 'master' function that calls the 
-- the type assignment functions:
-- 'predefinedprogram'
-- 'predefineddefinitionsmodule'
-- 'predefineddefinitionsmodules'
-- 'predefinedboolean'
-- 'predefinedtypeofvalue'
-- 'predefinedtypestateofvalue'
-- 'predefinedinteger'
-- 'predefinedtypename'
-- 'predefinedattribute_name'
-- The type assignment functions have signature: definitions -> typename.  

assign: USING(type, type_inference, errors, inferredType, positions)

PROCESS(SetupQ: SetupAssignQueue) 

DECLARE
  SetupM: SetupAssignMessage;
  AssignQ: AssignQueue;
  AssignC: AssignCapa;
  predefinedprogram: AssignRuleCapa;
  predefineddefinitionsmodule: AssignRuleCapa;
  predefineddefinitionsmodules: AssignRuleCapa;
  predefinedboolean: AssignRuleCapa;
  predefinedtypeofvalue: AssignRuleCapa;
  predefinedtypestateofvalue: AssignRuleCapa;
  predefinedinteger: AssignRuleCapa;
  predefinedtypename: AssignRuleCapa;
  predefinedattribute_name: AssignRuleCapa;
  findType: findTypeCapa;
  program: proc;
  defs: definitions_modules;
  blankError: error;
  error: error;
  errObj: errorObject;
  inference: InferredDefinition;
  bp: backpatchRecord;
  bpAssign: backpatchAssign;

BEGIN
  NEW AssignQ;
  CONNECT AssignC TO AssignQ;

  RECEIVE SetupM FROM SetupQ;

  -- load the individual assignment rule processes
  predefinedprogram <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefinedprogram")));
  predefineddefinitionsmodule <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefineddefinitionsmodule")));
  predefineddefinitionsmodules <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefineddefinitionsmodules")));
  predefinedboolean <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefinedboolean")));
  predefinedtypeofvalue <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefinedtypeofvalue")));
  predefinedtypestateofvalue <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefinedtypestateofvalue")));
  predefinedinteger <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefinedinteger")));
  predefinedtypename <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefinedtypename")));
  predefinedattribute_name <- AssignRuleCapa#(PROCEDURE OF program#(
      SetupM.load(charstring#"predefinedattribute_name")));
  -- keep a copy of the findType port and the absprog and definitions
  findType := SetupM.findType;
  program := SetupM.program;
  defs := SetupM.definitions;
  
  -- provide an output port to calling environment
  SetupM.assign_func <- AssignC;  

  RETURN SetupM;
  discard SetupQ;

  -- make a blank error object template so we can build error objects
  -- more easily when needed
  new blankError;
  blankError.code <- errorcode#'type assignment mismatch';
  new blankError.objects;

  -- now loop, handling requests
  while boolean#'true' repeat
    block declare
      AssignM: assignMessage;
      asgnType: typename;
      knownType: typename;
    begin
      receive AssignM from AssignQ;

      -- get type assigned by this rule
      select AssignM.function
      where (type_assignment_function#'predefinedprogram')
	asgnType <- typename#(predefinedprogram());
      where (type_assignment_function#'predefineddefinitionsmodule')
	asgnType <- typename#(predefineddefinitionsmodule());
      where (type_assignment_function#'predefineddefinitionsmodules')
	asgnType <- typename#(predefineddefinitionsmodules());
      where (type_assignment_function#'predefinedboolean')
	asgnType <- typename#(predefinedboolean());
      where (type_assignment_function#'predefinedtypeofvalue')
	asgnType <- typename#(predefinedtypeofvalue());
      where (type_assignment_function#'predefinedtypestateofvalue')
	asgnType <- typename#(predefinedtypestateofvalue());
      where (type_assignment_function#'predefinedinteger')
	asgnType <- typename#(predefinedinteger());
      where (type_assignment_function#'predefinedtypename')
	asgnType <- typename#(predefinedtypename());
      where (type_assignment_function#'predefinedattribute_name')
	asgnType <- typename#(predefinedattribute_name());
      otherwise
	exit cantHappen;
      end select;
      
      -- look up this type from declarations and current inferences
      block begin
	knownType <- typename#(findType(AssignM.object, 
	    program.executable_part.scopes, defs, AssignM.inferred));
	if boolean#(knownType <> asgnType) then
	  -- types don't match... issue an error
	  error := blankError;
	  unite error.position.apos from aposition#(copy of AssignM.position);
	  -- error objects are the objectname, its previously known
	  -- type, and its assigned type
	  unite errObj.objectname from objectname#(copy of AssignM.object);
	  insert errObj into error.objects;
	  unite errObj.typename from knownType;
	  insert errObj into error.objects;
	  unite errObj.typename from asgnType;
	  insert errObj into error.objects;
	  insert error into AssignM.errors;
	end if;
      on (findTypeMessage.unknown_type)
	-- type was previously unknown, so we infer it now if it's a
	-- root object.  Otherwise we need to backpatch for a check
	-- later
	if boolean#(integer#(size of AssignM.object.components) = integer#0)
	then
	  new inference;
	  inference.root := AssignM.object.root;
	  inference.type <- asgnType;
	  insert inference into AssignM.inferred;
	  block begin
	    insert rootname#(copy of AssignM.object.root) 
		into AssignM.newlyInferred;
	  on(DuplicateKey)
	  end block;
	else
	  new bp;
	  bp.triggerObj := AssignM.object.root;
	  new bpAssign;
	  bpAssign.function := AssignM.function;
	  bpAssign.resultObj := AssignM.object;
	  bpAssign.position := AssignM.position;
	  unite bp.info.assign from bpAssign;
	  insert bp into AssignM.backpatch;
	end if;
      end block;
      
      return AssignM;

    on exit(cantHappen)
    end block;
  end while;
end process

