-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: exceptionbr.p
-- Author: Rob Strom
-- SCCS Info: @(#)exceptionbr.p	1.3 3/13/90

-- Function: Locate destination.  GLB typestate with other branches to that destination
-- Algorithm:
-- 1. For each exception list in scope, starting at current:
--    If this scope handles this exception, you have destination
--    else if this scope handles "others" and this is an exception, not an exit,
--     you have destination
--    else try next outer scope
-- 2. When you have found the scope, GLB current typestate with destination.
--    EXCEPT don't do this if the branch is to level '1', because 
--    (provided this program was built with the front-end), level '1'
--    will be the outermost block with just an ON(OTHERS), and you don't
--    need to do anything except stick an empty typestate there and no
--    soft coercions, because the back end will automatically coerce
--    everything away.   This is a hack to improve performance
--    in this special case because it is so frequent.
exceptionbr : USING( Predefined, tscheck  ) PROCESS ( ExceptionBranchInit : ExceptionBranchInport )
  DECLARE
    FP: ExceptionBranchCall;
    Nothing:Empty;
  BEGIN
    RECEIVE FP From ExceptionBranchInit;
    BLOCK
      BEGIN
        FOR BlockDescriptor IN FP.Context.HandlerScopes WHERE('true')
          INSPECT
            BLOCK
              DECLARE
                HandlerCoercion: SoftCoercion; -- information about destination
              BEGIN
                INSPECT Handler IN BlockDescriptor.Handlers WHERE(Handler.Id = FP.Exception OR (CASE OF Handler.Id = 'others' AND CASE OF FP.Exception <> 'exit'))
		  BEGIN
		    IF BlockDescriptor.Level <= 1
		      THEN
			IF EXISTS OF HC IN FP.Context.HandlerCoercions WHERE(HC.ClauseId = Handler.Clause)
			  THEN
			  ELSE
			    NEW HandlerCoercion;
			    HandlerCoercion.ClauseId := Handler.Clause;
			    UNITE HandlerCoercion.Dataflow.Branched FROM EVALUATE CoercionInfo: CoercionInfo FROM
			      NEW CoercionInfo;
			      NEW CoercionInfo.TargetTS;
			      NEW CoercionInfo.Drops;
			      END;
			    INSERT HandlerCoercion INTO FP.Context.HandlerCoercions;
			  END IF;
		      ELSE
			BLOCK
			  BEGIN
			    REMOVE HandlerCoercion FROM HC IN FP.Context.HandlerCoercions WHERE(HC.ClauseId = Handler.Clause);
			  ON (NotFound)
			    NEW HandlerCoercion;
			    HandlerCoercion.ClauseId := Handler.Clause;
			    UNITE HandlerCoercion.Dataflow.NeverBranched FROM Nothing;
			  END BLOCK;
			CALL FP.Services.SoftGLB(FP.Services, FP.Declarations, FP.Context, FP.Definitions, FP.CurrentTS, BlockDescriptor.Level, HandlerCoercion.Dataflow);
			INSERT HandlerCoercion INTO FP.Context.HandlerCoercions;
		      END IF;
		  END INSPECT;
		EXIT Done;
              ON (NotFound)
              END BLOCK;
          END FOR;
      ON EXIT(Done)
      END BLOCK;
    RETURN FP;
  END PROCESS
