-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: involving.p
-- Author: Rob Strom
-- SCCS Info: @(#)involving.p	1.1 7/27/89

-- Function: Get attributes which must be dropped to lower TS to particular value
-- Algorithm:
-- Any attribute which is parametrized by that object
-- or by any subcomponent of that object and which is
-- not one of the corequisite attributes
-- Except: "parametrized" doesn't include the second component of CASE(V, V.A)
Involving : USING( Predefined, tscheck  ) PROCESS ( InvolvingInit : InvolvingInport )
  DECLARE
    FP: InvolvingCall;
  BEGIN
    RECEIVE FP From InvolvingInit;
      FP.Prerequisites <- EVERY OF Attribute IN FP.CurrentTS WHERE(NOT EXISTS OF FP.AttributeList[Attribute] AND EXISTS OF Object IN Attribute.Objects WHERE(EVALUATE Subset: Boolean FROM
      Subset <- FP.Object.Root = Object.Root AND SIZE OF FP.Object.Components <= SIZE OF Object.Components;
      IF Subset 
	THEN
	  Subset <- FORALL OF Component IN FP.Object.Components WHERE(Component = Object.Components[POSITION OF Component]);
	  IF POSITION OF Object = 1
	    THEN
	      IF CASE OF Attribute.Name = 'case'
		THEN
		  Subset <- 'false';
		END IF;
	    END IF;
	END IF;
      END));
    RETURN FP;
  END PROCESS
