-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pomvelts.p
-- Author: Rob Strom
-- SCCS Info: @(#)pomvelts.p	1.2 3/13/90

pomvelts : USING( tscheck, Predefined  ) PROCESS (PostMoveElementTSInit : DeterminePostconditionInport )
-- Compute Postcondition of TheElement, REMOVE
-- Similar to MOVE, except that what is moved is the entry typestate
-- rather than a current typestate
-- (For now, ignore the subtleties of REMOVE M FROM R IN M.P WHERE(...);)
-- Algorithm:
-- 1. Get the element formal typestate.
-- 2. Substitute the destination element object name into the formal typestate
-- 3. Put those attributes on the Adds list
-- 4. For each attribute involving destination object,
--    put that attribute in the Drops list unless it's in the Adds list
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    TableType: TypeName; -- type of the table
    ElementTypestate: Typestate; -- typestate of the element after REMOVE
    AttributesInvolvingDestination : Typestate;
    EmptyAttributeList:  Typestate;
    DeletedAttribute: Attribute;
  BEGIN
    RECEIVE FP FROM PostMoveElementTSInit ;
    INSPECT SourceObject IN FP.Statement.Operands WHERE(POSITION OF SourceObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
        INSPECT DestinationObject IN FP.Statement.Operands WHERE(POSITION OF DestinationObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 1))
          BEGIN
            NEW EmptyAttributeList; 
            -- 1.
	    TableType <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, SourceObject);
	    INSPECT Module IN FP.Definitions WHERE(Module.Id = TableType.ModuleId)
	      BEGIN
		INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = TableType.TypeId)
		  BEGIN
		    -- 2.
		    REVEAL Definition.Specification.Table_Info; 
		    CALL FP.Services.Substitute(FP.Services, DestinationObject, Definition.Specification.Table_Info.Element_Typestate, ElementTypestate);
		    -- 3.
		    MERGE ElementTypestate INTO FP.NormalPostcondition.Adds;
		  END INSPECT;
              END INSPECT;
	    -- 4.
	    CALL FP.Services.Involving(FP.CurrentTS, DestinationObject, EmptyAttributeList, AttributesInvolvingDestination);
	    WHILE (SIZE OF AttributesInvolvingDestination > 0)
	      REPEAT
	        REMOVE DeletedAttribute FROM Attribute IN AttributesInvolvingDestination WHERE('true');
	        IF EXISTS OF Mate IN FP.NormalPostcondition.Adds WHERE(Mate = DeletedAttribute)
	          THEN
	            DISCARD DeletedAttribute;
	          ELSE
	            INSERT DeletedAttribute INTO FP.NormalPostcondition.Drops;
	          END IF;
	      END WHILE;
          END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
