-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: tscc.p
-- Author: Rob Strom
-- SCCS Info: @(#)tscc.p	1.1 7/27/89

-- TSCC: Check Clause for Typestate Errors
-- If this is not the first time we've checked this clause,
--   then throw away any coercions we've generated previously
-- For each statement in the clause do these things:
-- 1.  DETERMINE PRECONDITION: 
--     Get the required and forbidden attrs of precondition, 
--     by calling precondition functions determined by table lookup.
--     (The precondition functions will also check VAR and POS requirements),
--     and for operations which have conditional checks (RangeError),
--     will generate conditional branches to handlers for them).
-- 2.  APPLY PRECONDITION:
--     Lower the typestate to the highest typestate which includes
--     all required attrs and excludes all forbidden ones.
-- 3.  If there is a selector, CHECK SELECTOR.
--     The checking table entry will indicate which operand position
--     contains the associated table
-- 4.  DETERMINE POSTCONDITION:
--     Lookup the operation in a table to determine the typestate changes:
--     There are 4 cases:
--     4A. "regular operations".  These have a normal outcome in which
--     the typestate may change, and exceptions in which nothing changes.
--       4A.1. For each exception, EXCEPTION BRANCH:  This discovers
--       which handler takes the exception, and propagates the typestate
--       to that point, computing the GLB typestate and soft coercions
--       for that destination.
--       4A.2. Call the postcondition rules given in the table.
--       This will build the add/drop list for the normal outcome.
--       4A.3. APPLY POSTCONDITION for the normal outcome.  This
--       will update the typestate and complain if the updated typestate 
--       violates a typestate compatibility rule.
--     4B. CALL.  Call statements can have exception outcomes, each with
--     different typestate.  
--       4B.1. Call the "callpostcondition" routine to determine
--       the adds/drops for all outcomes.
--       4B.2. For each exception:
--          4.B.2.1. APPLY POSTCONDITION to determine the new typestate
--          for that exception.
--          4.B.2.2. EXCEPTION BRANCH to propagate that typestate
--       4B.3. APPLY POSTCONDITION for the normal outcome.
--     4C. EXIT.  There is no normal outcome, only an exception outcome.
--       4C.1. EXCEPTION BRANCH to that outcome.
--       4C.2. If EXIT is not the last statement of the clause, complain
--             that the statement after EXIT is unreachable.
--       4C.3. Leave TSCC with an exception: NoNormalExit
--     4D. Compound Statement:  These have embedded clauses, and
--     each clause has its own control flow.  We handle these in
--     a case-by-case fashion.
--        4DA. block:
--           4DA.1. Insert new scope into path, remembering constants list,
--                  and exception handlers   
--           4DA.2. Check Main Clause. If it has a normal exit, branch to
--             end of clause (accumulate GLB).
--           4DA.3. Remove exception handlers from scope 
--           4DA.4. For each handler clause,
--             Make sure clause has been branched to (DeadCode error if not)
--	       Check the clause
--             If the clause has a normal exit,
--               branch to end of block.
--           4DA.5. At the end of all clauses, remove scope, constants from path
--              If at least one clause terminated normally,
--              normal exit typestate is GLB of branches.
--              If no clause terminated, then the block has no
--              normal exit.  Treat like case 4C.2 and 4C.3.
--        4DB. IF and SELECT:
--           exactly like BLOCK, except no constant list or handlers,
--           all ports and guard clause results must be INIT, and
--           guard expression clauses must terminate.
--           SELECT has a Disconnected exception
--        4DC. WHILE: 
--          Check While-Clause. It must terminate with result at least INIT.
--          Check Repeated Clause
--          If repeated clause terminates, coerce its ending TS
--            down to the typestate of the beginning of the clause.
--          The EXIT TS of WHILE is the same as the entry TS.
--        4DD: FOR INSPECT:
--          4DD.1. Check the selector (get table as for selector-qualified ops)
--          4DD.2. Put the induction variable in INSPECTING list, and constant
--          4DD.3. If the table is ordered, make the induction variable POS.
--          4DD.4. Put the induction variable in the element TS
--          4DD.5. Include the induction variable in a new scope
--          4DD.6. Check the repeated clause 
--          4DD.7. If the repeated clause terminates, coerce its ending TS
--            down to the TS at the beginning of the clause.
--          4DD.9. Pop all scopes, constants, inspecting, pos.
--          4DD.8. The EXIT TS is the GLB of the following two typestates:
--                 a. the loop begin TS less the induction variable's attributes
--                 b. the TS on entry to the FOR statement (omit if repeated clause has no normal exit).
--        4DE: INSPECT
--          4DE.1. Check the selector
--          4DE.1'. Exception Branch to NotFound builtin exception
--          4DE.2. Put the induction variable in INSPECTING list, and constant
--          4DE.3. If the table is ordered, make the induction variable POS.
--          4DE.4. Put the induction variable in the element TS
--          4DE.5  Include the induction variable in a new scope
--          4DE.6. Check the INSPECT clause
--          4DE.7. The exit ts (or absence) = the exit ts of the clause less induction variable.
--          4DE.8. If there is no exit ts, proceed as for BLOCK.
--        4DF: FOR ENUMERATE -- not supported yet
--        4DG: Expression Block:
--          Begin a new scope.
--          Check the main clause.  (If it has no exit, it will presumably
--            be followed by a statement and will cause an error).
TSCC :  USING(Predefined, tscheck, Errors, Checking_table, Typestate_Inference, Positions, Coercions )  PROCESS ( CheckClauseInit: CheckClauseInport )
  DECLARE
    FP: CheckClauseCall ;
    EmptyTS: Typestate;
    ErrorMessage: Error; -- typestate error message
    CheckSelector: CheckSelectorOutport;
  BEGIN
    CheckSelector <- PROCEDURE OF PROCESS (CheckSelectorInit: CheckSelectorInport)
    -- procedure to typestate check a selector
    -- 0. Treat the clause as a nested scope with the element variable POS
    -- 1. the typestate entering the clause = typestate of statement
    --    containing the selector + induction variable in element typestate
    -- 2. Check the select clause; complain if it doesn't exit
    -- 3. Check that the result variable is INIT or coercible to INIT
    -- 4. Drop INIT of the result 
    -- 5. Perform typestate check as if we were to branch back and re-execute the clause
    -- Implementation Notes:
    -- 1. Currently we rely on the fact that WHERE clauses are syntactically
    --    expressions to avoid the need to protect the constancy of objects
    --    which hypothetically could be modified by statements within a SELECTOR.
    -- 2. Currently we're not updating the typestate.  This is theoretically
    --    possible if statements nested within selectors drop constraints.
      DECLARE
        FP: CheckSelectorCall ;
        SelectorTS: Typestate; -- typestate within selector
        ExitTS: Typestate; -- typestate at end of selector
        TableType: Typename; -- type of table
        Nothing: Empty; -- what's in empty variants 
        InitResult: Attribute; -- expected typestate after evaluating WHERE
        InductionRootname: Rootname; -- root name of induction object
        ScopeStackEntry: ScopeId; -- entry in table of active scopes
        ErrorMessage: Error; -- uninit result complaint or dead code
        ErrorObject: ErrorObject; -- name of missiing attribute
      BEGIN
        RECEIVE FP FROM CheckSelectorInit;
        NEW InductionRootname;
        InductionRootname.Scope := FP.Selector.Scope;
        InductionRootname.Root := FP.Selector.Element;
	SelectorTS := FP.CurrentTS;
	/* put induction variable in element TS */
	TableType <- FP.Services.TypeOf(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, FP.Table);
	INSPECT Module IN FP.Definitions WHERE(Module.Id = TableType.ModuleId)
	  BEGIN
	    INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = TableType.TypeId)
	      BEGIN
	        REVEAL Definition.Specification.Table_Info;
                INSERT COPY OF InductionRootname INTO FP.Context.Constants AT(0);
	        INSERT COPY OF InductionRootname INTO FP.Context.Inspecting AT(0);
                INSERT COPY OF FP.Selector.Scope INTO FP.Context.Scopes;
	        IF Definition.Specification.Table_Info.Ordered_Table
	          THEN
	            INSERT COPY OF InductionRootname INTO FP.Context.Pos AT(0);
	          END IF;
		MERGE FP.Services.Substitute(FP.Services, (EVALUATE ElementObject: ObjectName FROM
		  NEW ElementObject;
		  ElementObject.Root := InductionRootName;
		  NEW ElementObject.Components;
		  END), Definition.Specification.Table_Info.Element_Typestate) INTO SelectorTS;
		/* ExamineScope: */ INSPECT BlockScope IN FP.Code.Scopes WHERE(BlockScope.ID = FP.Selector.Scope)
		  BEGIN
                    BLOCK
                      BEGIN
			CALL FP.Services.CheckClause(FP.Services, FP.Code, FP.Definitions, BlockScope.Clause, SelectorTS, ExitTS, FP.Context);
			NEW InitResult;
			UNITE InitResult.Name.Init FROM Nothing;
			NEW InitResult.Objects;
			INSERT COPY OF FP.Selector.Result INTO InitResult.Objects;
			IF EXISTS OF Attribute IN ExitTS WHERE(Attribute = InitResult)
			  THEN
			  ELSE
			    /* typestate error: missing required attribute */
			    
			    NEW ErrorMessage;
			    UNITE ErrorMessage.Position.APos FROM COPY OF FP.Position;
			    ErrorMessage.Code <- 'NotAsserted';
			    NEW ErrorMessage.Objects;
			    UNITE ErrorObject.Attribute FROM InitResult;
			    INSERT ErrorObject INTO ErrorMessage.Objects;
			    INSERT ErrorMessage INTO FP.Context.ErrorMessages;   
			  END IF;
	              ON (CheckClauseCall.NoNormalExit)
	                NEW ErrorMessage;
			UNITE ErrorMessage.Position.APos FROM COPY OF FP.Position;
			ErrorMessage.Code <- 'DeadCode';
			NEW ErrorMessage.Objects;
			INSERT ErrorMessage INTO FP.Context.ErrorMessages;
                      END BLOCK;
		  END INSPECT /* ExamineScope */;
	        REMOVE ScopeStackEntry FROM Foo IN FP.Context.Scopes WHERE(POSITION OF Foo = SIZE OF FP.Context.Scopes - 1);
	        REMOVE InductionRootname FROM Foo IN FP.Context.Inspecting WHERE(POSITION OF Foo = 0);
	        REMOVE InductionRootname FROM Foo IN FP.Context.Constants WHERE(POSITION OF Foo = 0);	        
	        IF Definition.Specification.Table_Info.Ordered_Table
	          THEN
	            REMOVE InductionRootname FROM Foo IN FP.Context.Pos WHERE(POSITION OF Foo = 0);
	          END IF;
	      END INSPECT;
	  END INSPECT;
        RETURN FP;
      END PROCESS;
    
    NEW EmptyTS; 
    RECEIVE FP FROM CheckClauseInit ;
    /* ObtainClause */ BLOCK
      DECLARE
        Required: Typestate; -- attributes which must be present
        Forbidden: Typestate; -- attributes which must be absent
        Position: Aposition; -- the position of this statement
        Coercion: Coercion; -- coercion being removed
      BEGIN
        INSPECT TheClause IN FP.Code.Clauses WHERE(TheClause.Id = FP.Clause)
          BEGIN
            FP.ExitTS := FP.EntryTS;
            FOR TheStatement IN TheClause.Statements WHERE ('true')
              INSPECT
--              /* debug */ CALL FP.Services.Outside.Terminal.PutLine(FP.Services.Debug.FormatTypestate(FP.Services.Debug, FP.Definitions, FP.Code.Scopes, FP.Context.InferredDcls, FP.Context.DefinitionsMap, FP.Context.ExecutableMap, FP.ExitTS));
                NEW Position;
                Position.Clause := TheClause.Id;
                Position.Statement := TheStatement.Id;
                BLOCK
                  BEGIN
                    REMOVE Coercion FROM C IN FP.Context.PreCoercions[Position];
                  ON (NotFound)
                  END BLOCK;
                BLOCK
                  BEGIN
                    REMOVE Coercion FROM C IN FP.Context.PostCoercions[Position];
                  ON (NotFound)
                  END BLOCK;
--              /* debug */ CALL FP.Services.Outside.Terminal.PutLine(FP.Services.Debug.FormatStatement(FP.Services.Debug, FP.Code.Scopes, FP.Context.InferredDcls, FP.Definitions, FP.Context.DefinitionsMap, FP.Context.ExecutableMap, TheStatement));
                -- 1.
                INSPECT OperationDescriptor IN FP.Services.Checking_Table WHERE (OperationDescriptor.Operator = TheStatement.Operator)
                  BEGIN
                    NEW Required;
                    NEW Forbidden;
                    FOR PreconditionRule IN OperationDescriptor.Precondition_Rules WHERE('true')
                      INSPECT
                        INSPECT PreconditionFunctionEntry IN FP.Services.PreconditionFunctions WHERE(PreconditionFunctionEntry.Name = PreconditionRule.Precondition_Function)
                          BEGIN
                            CALL PreconditionFunctionEntry.Function(FP.Services, FP.Definitions, FP.Code.Scopes, FP.Context, TheStatement, Position, FP.ExitTS, PreconditionRule.Affected_Operands, Required, Forbidden);
                          END INSPECT;
                      END FOR;
		    -- 2.
		    CALL FP.Services.ApplyPrecondition(FP.Services, FP.Code.Scopes, FP.Definitions, Position, FP.Context, Required, Forbidden, FP.ExitTS);
		    -- 3.
		    IF CASE OF TheStatement.Qualifier = 'selector'
		      THEN
			REVEAL TheStatement.Qualifier.Selector;
			REVEAL OperationDescriptor.Qualifier_Info.Selector;
			INSPECT Table IN TheStatement.Operands WHERE(POSITION OF Table = OperationDescriptor.Qualifier_Info.Selector)
			  BEGIN
			    CALL CheckSelector(FP.Services, FP.Code, FP.Definitions, Position, TheStatement.Qualifier.Selector, Table, FP.ExitTS, FP.Context);
			  END INSPECT;
		      END IF;
		    -- 4.
		    /* CheckPostConditions */ BLOCK
		      DECLARE
			NormalPostCondition: AddDropSet; -- normal changes to TS
			ExceptionPostConditions: AddDropSets; -- exception changes
			NextAlternative: NextAlternativeOutport; -- check an alternative clause
			EndAlternatives: EndAlternativesOutport; -- report the GLB from a set of alternative clauses
			NullAlternative: NullAlternativeOutport; -- like NextAlternative except when clause isn't there
			Nothing: Empty; -- empty option
			BitBucketTS: Typestate; -- used by REMOVE meaning delete
			BitBucketScope: ScopeId; -- ditto
			BitBucketEBD: ExpressionBlockDescriptor; -- ditto
			BitBucketRootname: Rootname; -- ditto
			BitBucketAttr: Attribute; -- ditto
			LoopUnchecked: Boolean; -- true until typestate at end of loop coercible to typestate at beginning
			BeginLoopTS: Typestate; -- typestate at beginning of loop
			PreInspectionTS: Typestate; -- typestate before entering FOR INSPECT statement
			TableType: TypeName; -- type of table being inspected
			InductionRootname: RootName; -- root name of induction variable of FOR INSPECT or INSPECT
		      BEGIN
			SELECT (CASE OF OperationDescriptor.Postcondition_Rules)
			  WHERE ('regular')
			  -- 4A.
			    REVEAL OperationDescriptor.Postcondition_Rules.RegularRule;
			    -- 4A.1.
			    FOR Exception IN OperationDescriptor.Postcondition_Rules.RegularRule.Exceptions WHERE('true')
			      INSPECT
			        CALL FP.Services.ExceptionBranch(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, (EVALUATE ExceptionHandler : HandlerName FROM
			          UNITE ExceptionHandler.Builtin FROM COPY OF Exception;
			          END), FP.ExitTS);
			      END FOR;
			    -- 4A.2.
			    NEW NormalPostCondition;
			    NEW NormalPostCondition.Adds;
			    NEW NormalPostCondition.Drops;
			    FOR Rule IN OperationDescriptor.Postcondition_Rules.RegularRule.Rule WHERE('true')
			      INSPECT
				INSPECT RegularRuleEntry IN FP.Services.PostconditionRegularFunctions WHERE(RegularRuleEntry.Name = Rule.PostconditionFunction)
				  BEGIN
				    CALL RegularRuleEntry.Function(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, TheStatement,  FP.ExitTS, Rule.AffectedOperands, NormalPostcondition);
				  END INSPECT;
			      END FOR;
			    -- 4A.3.
			    CALL FP.Services.ApplyPostcondition(FP.Services, FP.Code.Scopes, FP.Definitions, Position,  FP.Context, NormalPostCondition, FP.ExitTS);
			  WHERE ('call')
			    -- 4B.1.
		            CALL FP.Services.DetermineCallPostcondition(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, TheStatement, FP.ExitTS, NormalPostcondition, ExceptionPostconditions);
		            -- 4B.2.
			    /* ProcessExceptions */ BLOCK
			      DECLARE
			        ExceptionPostCondition: LabelledAddDropSet; 
			      BEGIN
			        WHILE ('true')
			          REPEAT
			            REMOVE ExceptionPostCondition FROM EPC IN ExceptionPostconditions[];
				    -- for efficiency, don't apply postcondition if post=pre
				    IF SIZE OF ExceptionPostCondition.AddDropSet.Adds + SIZE OF ExceptionPostCondition.AddDropSet.Drops > 0
				      THEN
					BLOCK
					  DECLARE
					    DestinationTS: Typestate; -- typestate after adds/drops applied
					  BEGIN
					    DestinationTS := FP.ExitTS;
					    -- 4B.2.1.
					    CALL FP.Services.ApplyPostcondition(FP.Services,FP.Code.Scopes, FP.Definitions, Position, FP.Context, ExceptionPostCondition.AddDropSet, DestinationTS);
					    -- 4B.2.2.
					    CALL FP.Services.ExceptionBranch(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, ExceptionPostCondition.ExceptionName, DestinationTS);
					  END BLOCK;
				      ELSE
					-- 4B.2.1, 2.
					CALL FP.Services.ExceptionBranch(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, ExceptionPostCondition.ExceptionName, FP.ExitTS);
				      END IF;
				  END WHILE;
		              ON (NotFound) -- terminate when all exceptions prcessed
			      END BLOCK /* ProcessExceptions */;
			    -- 4B.2.3.
			    CALL FP.Services.ApplyPostcondition(FP.Services, FP.Code.Scopes, FP.Definitions, Position, FP.Context, NormalPostCondition, FP.ExitTS);
			  WHERE ('exit')
			    -- 4C.
			    REVEAL TheStatement.Qualifier.Exit;
			    CALL FP.Services.ExceptionBranch(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, (EVALUATE ExitHandler: HandlerName FROM
			      UNITE ExitHandler.Exit FROM COPY OF TheStatement.Qualifier.Exit;
			      END), FP.ExitTS);
			    EXIT NoNormalExit;
			  OTHERWISE -- WHERE 'compound'
			    SELECT (TheStatement.Operator)
			      WHERE ('block')
			        -- 4DA.
				BLOCK
				  DECLARE
				    PreviousNumberConstants: Integer; -- how many constants were on list before beginning of block
				    DeletedBlockDescriptor: BlockDescriptor; -- handlers of this block
				    Constants: RootnameList; -- artificial variable because of no DELETE statement
				  BEGIN
				    REVEAL TheStatement.Qualifier.Block;
				    /* ExamineScope: */ INSPECT BlockScope IN FP.Code.Scopes WHERE(BlockScope.Id = TheStatement.Qualifier.Block.Scope)
				      BEGIN
				        -- 4DA.1.
					CALL FP.Services.BeginAlternatives(FP.Services, NextAlternative, EndAlternatives, NullAlternative);
					PreviousNumberConstants <- SIZE OF FP.Context.Constants;
					INSERT COPY OF BlockScope.Id INTO FP.Context.Scopes;
					FOR Constant IN TheStatement.Qualifier.Block.Constants WHERE('true')
					  INSPECT
					    INSERT COPY OF Constant INTO FP.Context.Constants;
					  END FOR;
					INSERT (EVALUATE BlockDescriptor: BlockDescriptor FROM
					  NEW BlockDescriptor;
					  BlockDescriptor.Handlers := TheStatement.Qualifier.Block.Handlers;
					  BlockDescriptor.Level <- CONVERT OF SIZE OF FP.Context.Scopes - 1;
					  END) INTO FP.Context.HandlerScopes AT(0);
					-- 4DA.2.
					CALL NextAlternative(FP.Services, FP.Code, FP.Definitions, BlockScope.Clause, FP.ExitTS, FP.Context);
					-- 4DA.3.
					REMOVE DeletedBlockDescriptor FROM StackEntry IN FP.Context.HandlerScopes WHERE(POSITION OF StackEntry = 0);
					-- 4DA.4.
					FOR Handler IN TheStatement.Qualifier.Block.Handlers WHERE('true')
					  INSPECT
					    /* MakeSureHandlerIsLive:*/ BLOCK
					      BEGIN
						INSPECT HandlerInfo IN FP.Context.HandlerCoercions WHERE(HandlerInfo.ClauseId = Handler.Clause)
						  BEGIN
						    REVEAL HandlerInfo.Dataflow.Branched;
						    CALL NextAlternative(FP.Services, FP.Code, FP.Definitions, Handler.Clause, HandlerInfo.Dataflow.Branched.TargetTS, FP.Context);
						   
						  END INSPECT;
						ON (CaseError) 
						  NEW ErrorMessage;
						  UNITE ErrorMessage.Position.APos FROM COPY OF Position;
						  ErrorMessage.Code <- 'DeadCode';
						  NEW ErrorMessage.Objects;
						  INSERT ErrorMessage INTO FP.Context.ErrorMessages;   
						ON (NotFound) 
						  NEW ErrorMessage;
						  UNITE ErrorMessage.Position.APos FROM COPY OF Position;
						  ErrorMessage.Code <- 'DeadCode';
						  NEW ErrorMessage.Objects;
						  INSERT ErrorMessage INTO FP.Context.ErrorMessages;   
					      END BLOCK /* MakeSureHandlerIsLive */;
					  END FOR;
				      END INSPECT /* ExamineScope */;
				    -- 4DA.5
				    REMOVE BitBucketScope FROM StackEntry IN FP.Context.Scopes WHERE(POSITION OF StackEntry = SIZE OF FP.Context.Scopes - 1);
				    WHILE (SIZE OF FP.Context.Constants > PreviousNumberConstants)
				      REPEAT
					REMOVE BitBucketRootname FROM StackEntry IN FP.Context.Constants WHERE(POSITION OF StackEntry = SIZE OF FP.Context.Constants - 1);
				      END WHILE;
				    -- determine whether control flows to end or not
				    CALL EndAlternatives(FP.Services, FP.Code, FP.Definitions, FP.Context, Position, FP.ExitTS);
				  ON (EndAlternativesCall.NoNormalExit)
				    EXIT NoNormalExit;
				  END BLOCK;
			      WHERE ('if')
			        -- 4DB.
				BLOCK
				  DECLARE
				  BEGIN
				    REVEAL TheStatement.Qualifier.If;
				    CALL FP.Services.BeginAlternatives(FP.Services, NextAlternative, EndAlternatives, NullAlternative);
				    BLOCK
				      BEGIN
				        CALL FP.Services.CheckGuardClause(FP.Services, FP.Code, FP.Definitions, TheStatement.Qualifier.If.Test_Clause, Position, TheStatement.Qualifier.If.Test_Result, (COPY OF FP.ExitTS), FP.ExitTS, FP.Context);
				      ON (CheckGuardClauseCall.NoNormalExit)
				        EXIT NoNormalExit;
				      END BLOCK;
				    CALL NextAlternative(FP.Services, FP.Code, FP.Definitions, TheStatement.Qualifier.If.Then_Clause, FP.ExitTS, FP.Context);
				    IF CASE OF TheStatement.Qualifier.If.Opt_Else_Clause = 'present'
				      THEN
				        REVEAL TheStatement.Qualifier.If.Opt_Else_Clause.ClauseId;
				        CALL NextAlternative(FP.Services, FP.Code, FP.Definitions, TheStatement.Qualifier.If.Opt_Else_Clause.ClauseId, FP.ExitTS, FP.Context);
				      ELSE
				        CALL NullAlternative(FP.Services, FP.Code, FP.Definitions, FP.ExitTS, FP.Context);
				      END IF;
				    CALL EndAlternatives(FP.Services, FP.Code, FP.Definitions, FP.Context, Position, FP.ExitTS);
				  ON (EndAlternativesCall.NoNormalExit)
				    EXIT NoNormalExit;
				  END BLOCK;
			      WHERE ('select')
			        -- 4DB.
				BLOCK
				  DECLARE
				  BEGIN
				    REVEAL TheStatement.Qualifier.Select;
				    IF EXISTS OF SC IN TheSTatement.Qualifier.Select.Clauses WHERE(CASE OF SC.Info <> 'boolean')
				      THEN
				        CALL FP.Services.ExceptionBranch(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, (EVALUATE ExceptionHandler: HandlerName FROM
				          UNITE ExceptionHandler.Builtin FROM 'Disconnected';
				          END), FP.ExitTS);
				      END IF;
				    CALL FP.Services.BeginAlternatives(FP.Services, NextAlternative, EndAlternatives, NullAlternative);
				    FOR SelectClause IN TheStatement.Qualifier.Select.Clauses WHERE('true')
				      INSPECT
				        SELECT (CASE OF SelectClause.Info)
				          WHERE ('boolean')
				            REVEAL SelectClause.Info.Boolean;
				            BLOCK
				              BEGIN
				                CALL FP.Services.CheckGuardClause(FP.Services, FP.Code, FP.Definitions, SelectClause.Info.Boolean.Clause, Position, SelectClause.Info.Boolean.Result, (COPY OF FP.ExitTS), FP.ExitTS, FP.Context);
				              ON (CheckGuardClauseCall.NoNormalExit)
				                EXIT NoNormalExit;
				              END BLOCK;
				          WHERE ('event')
				            REVEAL SelectClause.Info.Portname;
				            -- should ports be CONSTANT too?
				            CALL FP.Services.ApplyPrecondition(FP.Services, FP.Code.Scopes, FP.Definitions, Position, FP.Context, (EVALUATE InitPortTS: Typestate FROM
				              NEW InitPortTS;
				              INSERT (EVALUATE InitPort: Attribute FROM
				                NEW InitPort;
				                UNITE InitPort.Name.Init FROM EVALUATE Nothing1: EMPTY FROM END;
				                NEW InitPort.Objects;
				                INSERT COPY OF SelectClause.Info.Portname INTO InitPort.Objects;
				                END) INTO InitPortTS;
				              END), EmptyTS, FP.ExitTS);
				          OTHERWISE -- WHERE ('both')
				            REVEAL SelectClause.Info.Both;
				            -- should ports be CONSTANT too?
				            CALL FP.Services.ApplyPrecondition(FP.Services, FP.Code.Scopes, FP.Definitions, Position, FP.Context, (EVALUATE InitPortTS2: Typestate FROM
				              NEW InitPortTS2;
				              INSERT (EVALUATE InitPort2: Attribute FROM
				                NEW InitPort2;
				                UNITE InitPort2.Name.Init FROM EVALUATE Nada: Empty FROM END;
				                NEW InitPort2.Objects;
				                INSERT COPY OF SelectClause.Info.Both.Portname INTO InitPort2.Objects;
				                END) INTO InitPortTS2;
				              END), EmptyTS, FP.ExitTS);
				            BLOCK
				              BEGIN
				                CALL FP.Services.CheckGuardClause(FP.Services, FP.Code, FP.Definitions, SelectClause.Info.Both.Boolean.Clause, Position, SelectClause.Info.Both.Boolean.Result, (COPY OF FP.ExitTS), FP.ExitTS, FP.Context);
				              ON (CheckGuardClauseCall.NoNormalExit)
				                EXIT NoNormalExit;
				              END BLOCK;
				          END SELECT;
				      END FOR;
				    FOR SelectClause IN TheStatement.Qualifier.Select.Clauses WHERE('true')
				      INSPECT
				        CALL NextAlternative(FP.Services, FP.Code, FP.Definitions, SelectClause.Clause, FP.ExitTS, FP.Context);
				      END FOR;
				    CALL NextAlternative(FP.Services, FP.Code, FP.Definitions, TheStatement.Qualifier.Select.Otherwise_Clause, FP.ExitTS, FP.Context);
				    CALL EndAlternatives(FP.Services, FP.Code, FP.Definitions, FP.Context, Position, FP.ExitTS);
				  ON (EndAlternativesCall.NoNormalExit)
				    EXIT NoNormalExit;
				  END BLOCK;
			      WHERE ('while')
			        -- 4DC.
			        REVEAL TheStatement.Qualifier.While;
				BLOCK
				  DECLARE
				    AfterTestTS : Typestate; -- typestate between executing the while test and the repeat clause
				  BEGIN
				    BeginLoopTS := FP.ExitTS;
				    WHILE ('true')
				      REPEAT
					CALL FP.Services.CheckGuardClause(FP.Services, FP.Code, FP.Definitions, TheStatement.Qualifier.While.Test_Clause, Position, TheStatement.Qualifier.While.Result, BeginLoopTS, FP.ExitTS, FP.Context);
					AfterTestTS := FP.ExitTS;
				        CALL FP.Services.CheckClause(FP.Services, FP.Code, FP.Definitions, TheStatement.Qualifier.While.Repeated_Clause, AfterTestTS, FP.ExitTS, FP.Context);
  				        CALL FP.Services.CheckLoop(FP.Services, FP.Code, FP.Definitions, FP.Context, BeginLoopTS, FP.ExitTS, LoopUnchecked, TheStatement.Qualifier.While.Test_Clause);
                                        if LoopUnchecked
                                          then
                                          else
                                            exit Done;
                                          end if;
				      END WHILE;
				  ON (CheckGuardClauseCall.NoNormalExit)
				    EXIT NoNormalExit;
				  ON Exit(Done)
		       	            FP.ExitTS <- AfterTestTS;
	                          ON (CheckClauseCall.NoNormalExit)
		       	            FP.ExitTS <- AfterTestTS;
				  END BLOCK;
			      WHERE ('for_inspect')
				REVEAL TheStatement.Qualifier.Inspect_Table;
				-- 4DD.1.
				REVEAL OperationDescriptor.Qualifier_Info.Selector;
				INSPECT Table IN TheStatement.Operands WHERE(POSITION OF Table = OperationDescriptor.Qualifier_Info.Selector)
				  BEGIN
				    CALL CheckSelector(FP.Services, FP.Code, FP.Definitions, Position, TheStatement.Qualifier.Inspect_Table.Selector, Table, FP.ExitTS, FP.Context);
				    TableType <- FP.Services.TypeOf(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, Table);
				    INSPECT Module IN FP.Definitions WHERE(Module.Id = TableType.ModuleId)
				      BEGIN
					INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = TableType.TypeId)
					  BEGIN
					    REVEAL Definition.Specification.Table_Info;
				            -- 4DD.2.
				            NEW InductionRootname;
				            InductionRootname.Scope := TheStatement.Qualifier.Inspect_Table.Scope;
				            InductionRootname.Root := TheStatement.Qualifier.Inspect_Table.Element;
				            INSERT COPY OF InductionRootname INTO FP.Context.Inspecting AT(0);
				            INSERT COPY OF InductionRootname INTO FP.Context.Constants AT(0);
				            -- 4DD.3.
				            IF Definition.Specification.Table_Info.Ordered_Table
				              THEN
				                INSERT COPY OF InductionRootname INTO FP.Context.Pos AT(0);
				              END IF;
				            -- 4DD.4.
				            PreInspectionTS := FP.ExitTS;
					    MERGE FP.Services.Substitute(FP.Services, (EVALUATE InductionObject: Objectname FROM
				              NEW InductionObject;
				              InductionObject.Root := InductionRootname;
				              NEW InductionObject.Components;
				              END), Definition.Specification.Table_Info.Element_Typestate) INTO FP.ExitTS;
					    -- 4DD.5.
					    INSERT COPY OF TheStatement.Qualifier.Inspect_Table.Scope INTO FP.Context.Scopes;
					    -- 4DD.6.
					    BLOCK
					      DECLARE
					        JoinTS: OptCoercionInfo; -- to compute GLB of entry TS and loop begin TS
					      BEGIN
					        BeginLoopTS := FP.ExitTS;
					        WHILE ('true')
					          REPEAT
					            INSPECT ForScope IN FP.Code.Scopes WHERE(ForScope.Id = TheStatement.Qualifier.Inspect_Table.Scope)
					              BEGIN
					                CALL FP.Services.CheckClause(FP.Services, FP.Code, FP.Definitions, ForScope.Clause, BeginLoopTS, FP.ExitTS, FP.Context);
					                -- 4DD.7.
  				                        CALL FP.Services.CheckLoop(FP.Services,FP.Code, FP.Definitions, FP.Context, BeginLoopTS, FP.ExitTS, LoopUnchecked, ForScope.Clause);
                                                        IF LoopUnchecked
                                                          then
                                                          else
                                                            Exit Done;
                                                          end if;
					              END INSPECT;
					          END WHILE;
					      ON Exit(Done)
					        UNITE JoinTS.Branched FROM EVALUATE CoercionInfo: CoercionInfo FROM
					          NEW CoercionInfo;
					          CoercionInfo.TargetTS := BeginLoopTS;
					          NEW CoercionInfo.Drops;
					          END;
					        DISCARD BeginLoopTS;
					        EXTRACT BitBucketTS FROM Attr IN JoinTS.Branched.TargetTS WHERE(EXISTS OF Object IN Attr.Objects WHERE(Object.Root = InductionRootName));
					        CALL FP.Services.SoftGLB(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, PreInspectionTS, CONVERT OF SIZE OF FP.Context.Scopes - 1, JoinTS);
					        REVEAL JoinTS.Branched;
					        FP.ExitTS := JoinTS.Branched.TargetTS;
					        IF SIZE OF JoinTS.Branched.Drops > 0
					          THEN
					            NEW Coercion;
					            Coercion.Position := Position;
					            Coercion.Coercions <- FP.Services.SoftCoerce(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, JoinTS.Branched.Drops); 
					            INSERT Coercion INTO FP.Context.PostCoercions;
					          END IF;
					      ON (CheckClauseCall.NoNormalExit)
					        FP.ExitTS <- PreInspectionTS;
					      END BLOCK;
					    -- 4DD.9.
					    REMOVE InductionRootName FROM Root IN FP.Context.Constants WHERE(POSITION OF Root = 0);
					    REMOVE InductionRootName FROM Root IN FP.Context.Inspecting WHERE(POSITION OF Root = 0);
					    IF Definition.Specification.Table_Info.Ordered_Table
					      THEN
					        REMOVE InductionRootName FROM Root IN FP.Context.Pos WHERE(POSITION OF Root = 0);
					      END IF;
					    REMOVE BitBucketScope FROM Scope IN FP.Context.Scopes WHERE(POSITION OF Scope = SIZE OF FP.Context.Scopes - 1);
					  END INSPECT;
				      END INSPECT;
				  END INSPECT;
			      WHERE ('inspect_table')
				REVEAL TheStatement.Qualifier.Inspect_Table;
				-- 4DE.1.
				REVEAL OperationDescriptor.Qualifier_Info.Selector;
				INSPECT Table IN TheStatement.Operands WHERE(POSITION OF Table = OperationDescriptor.Qualifier_Info.Selector)
				  BEGIN
				    CALL CheckSelector(FP.Services, FP.Code, FP.Definitions, Position, TheStatement.Qualifier.Inspect_Table.Selector, Table, FP.ExitTS, FP.Context);
				    -- 4DE.1'.
				    CALL FP.Services.ExceptionBranch(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, (EVALUATE ExceptionHandler : HandlerName FROM
			              UNITE ExceptionHandler.Builtin FROM 'NotFound';
			              END), FP.ExitTS);
				    TableType <- FP.Services.TypeOf(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Context, Table);
				    INSPECT Module IN FP.Definitions WHERE(Module.Id = TableType.ModuleId)
				      BEGIN
					INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = TableType.TypeId)
					  BEGIN
					    REVEAL Definition.Specification.Table_Info;
				            -- 4DE.2.
				            NEW InductionRootname;
				            InductionRootname.Scope := TheStatement.Qualifier.Inspect_Table.Scope;
				            InductionRootname.Root := TheStatement.Qualifier.Inspect_Table.Element;
				            INSERT COPY OF InductionRootname INTO FP.Context.Inspecting AT(0);
				            INSERT COPY OF InductionRootname INTO FP.Context.Constants AT(0);
				            -- 4DE.3.
				            IF Definition.Specification.Table_Info.Ordered_Table
				              THEN
				                INSERT COPY OF InductionRootname INTO FP.Context.Pos AT(0);
				              END IF;
				            -- 4DE.4.
					    MERGE FP.Services.Substitute(FP.Services, (EVALUATE InductionObject2: Objectname FROM
				              NEW InductionObject2;
				              InductionObject2.Root := InductionRootname;
				              NEW InductionObject2.Components;
				              END), Definition.Specification.Table_Info.Element_Typestate) INTO FP.ExitTS;
					    -- 4DE.5.
					    INSERT COPY OF TheStatement.Qualifier.Inspect_Table.Scope INTO FP.Context.Scopes;
					    -- 4DE.6., 4DE.7.
					    BLOCK
					      BEGIN
					        INSPECT InspectScope IN FP.Code.Scopes WHERE(InspectScope.Id = TheStatement.Qualifier.Inspect_Table.Scope)
					          BEGIN
					            CALL FP.Services.CheckClause(FP.Services, FP.Code, FP.Definitions, InspectScope.Clause, COPY OF FP.ExitTS, FP.ExitTS, FP.Context);
					          END INSPECT;
					      ON (CheckClauseCall.NoNormalExit)
						-- 4DE.8.
						REMOVE InductionRootName FROM Root IN FP.Context.Constants WHERE(POSITION OF Root = 0);
						REMOVE InductionRootName FROM Root IN FP.Context.Inspecting WHERE(POSITION OF Root = 0);
						IF Definition.Specification.Table_Info.Ordered_Table
						  THEN
						    REMOVE InductionRootName FROM Root IN FP.Context.Pos WHERE(POSITION OF Root = 0);
						  END IF;
						REMOVE BitBucketScope FROM Scope IN FP.Context.Scopes WHERE(POSITION OF Scope = SIZE OF FP.Context.Scopes - 1);
                                                EXIT NoNormalExit;
					      END BLOCK;
					    -- 4DE.8.
					    REMOVE InductionRootName FROM Root IN FP.Context.Constants WHERE(POSITION OF Root = 0);
					    REMOVE InductionRootName FROM Root IN FP.Context.Inspecting WHERE(POSITION OF Root = 0);
					    IF Definition.Specification.Table_Info.Ordered_Table
					      THEN
					        REMOVE InductionRootName FROM Root IN FP.Context.Pos WHERE(POSITION OF Root = 0);
					      END IF;
					    REMOVE BitBucketScope FROM Scope IN FP.Context.Scopes WHERE(POSITION OF Scope = SIZE OF FP.Context.Scopes - 1);
  					    EXTRACT BitBucketTS FROM Attr IN FP.ExitTS WHERE(EXISTS OF Object IN Attr.Objects WHERE(Object.Root = InductionRootName));
					  END INSPECT;
				      END INSPECT;
				  END INSPECT;
			      WHERE ('expression_block')
			        REVEAL TheStatement.Qualifier.Expression;
			        INSERT COPY OF TheStatement.Qualifier.Expression.Scope INTO FP.Context.Scopes;
			        INSERT (EVALUATE EBD: ExpressionBlockDescriptor FROM
			          NEW EBD;
			          EBD.Scope <- CONVERT OF (SIZE OF FP.Context.Scopes) - 1;
			          EBD.Result := TheStatement.Qualifier.Expression.Result;
			          END) INTO FP.Context.ExpressionBlocks;
			        BLOCK
			          BEGIN
			            INSPECT ExpressionBlockScope IN FP.Code.Scopes WHERE(ExpressionBlockScope.Id = TheStatement.Qualifier.Expression.Scope)
			              BEGIN
			                CALL FP.Services.CheckClause(FP.Services, FP.Code, FP.Definitions, ExpressionBlockScope.Clause, COPY OF FP.ExitTS, FP.ExitTS, FP.Context);
			              END INSPECT;
			          ON (CheckClauseCall.NoNormalExit)
			            EXIT NoNormalExit;
			          END BLOCK;
			        REMOVE BitBucketScope FROM Scope IN FP.Context.Scopes WHERE(POSITION OF Scope = SIZE OF FP.Context.Scopes - 1);
			        REMOVE BitBucketEBD FROM EBD2 IN FP.Context.ExpressionBlocks WHERE(POSITION OF EBD2 = SIZE OF FP.Context.ExpressionBlocks - 1); 
			      OTHERWISE -- for enumerate, inspect polymorph
			      END SELECT;
			  END SELECT;
	              ON EXIT(NoNormalExit)
	                IF POSITION OF TheStatement <> SIZE OF TheClause.Statements - 1 
	                  THEN
			    NEW ErrorMessage;
			    UNITE ErrorMessage.Position.APos FROM COPY OF Position;
			    ErrorMessage.Code <- 'DeadCode';
			    NEW ErrorMessage.Objects;
			    INSERT ErrorMessage INTO FP.Context.ErrorMessages;
	                  END IF;
	                EXIT NoNormalExit;
		      END BLOCK /* CheckPostConditions */;
                  END INSPECT;
              END FOR;
          END INSPECT;
        RETURN FP;
      ON EXIT(NoNormalExit)
        RETURN FP Exception NoNormalExit;
      END BLOCK /* ObtainClause */;
  END PROCESS 
  
