-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: tstypeof.p
-- Author: Rob Strom
-- SCCS Info: @(#)tstypeof.p	1.2 3/13/90

TSTypeOf : USING( tscheck, Predefined ) PROCESS ( TypeOfInit : TypeOfInport)
-- Procedure to determine the type of an object
-- Algorithm:
-- 1. Get the type of the root
--    1.1. First look in the explicit declarations
--    1.2. If not found, look in the Inferred Types table
-- 2. For each component, look at the component declaration associated
--    with the parent's type definition
-- Since type resolution has already been done, we assume the above
-- will always succeed.
  DECLARE
    FP: TypeOfCall ;
    ComponentOrdinal: integer;
  BEGIN
    RECEIVE FP FROM TypeOfInit ;

    INSPECT RootScope IN FP.Declarations WHERE(boolean # (FP.Object.Root.Scope = Rootscope.Id))
      BEGIN
        BLOCK
          BEGIN
            INSPECT Declaration IN RootScope.Declarations WHERE(boolean # (Declaration.Id = FP.Object.Root.Root))
              BEGIN
                REVEAL Declaration.Typename.Typename;
                FP.Type := Declaration.Typename.Typename;
              END INSPECT;
          ON (CaseError)
            INSPECT Declaration IN FP.Context.InferredDcls WHERE(boolean # (Declaration.Root = FP.Object.Root))
              BEGIN
                FP.Type := Declaration.Type;
              END INSPECT;
          END BLOCK;
      END INSPECT;
    ComponentOrdinal <- integer # 0;
    WHILE (boolean # (ComponentOrdinal < integer #(SIZE OF FP.Object.Components)))
      REPEAT
	INSPECT Module IN FP.Definitions WHERE(boolean # (Module.Id = FP.Type.ModuleId))
	  BEGIN
	    INSPECT Definition IN Module.Type_Definitions WHERE(boolean # (Definition.Id = FP.Type.TypeId))
	      BEGIN
		INSPECT ComponentDeclaration IN Definition.Component_Declarations WHERE(boolean # (ComponentDeclaration.Id = componentid # (ComponentId IN FP.Object.Components WHERE(boolean # (integer # (POSITION OF ComponentId) = ComponentOrdinal)))))
		  BEGIN
		    FP.Type := ComponentDeclaration.Type;
		  END INSPECT;
	      END INSPECT;
	  END INSPECT;
	ComponentOrdinal <- integer # (ComponentOrdinal + integer # 1);
      END WHILE;
    
    RETURN FP;
  END PROCESS
