/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#include <stdio.h>
#include <fcntl.h>
#include <suntool/sunview.h>
#include <suntool/tty.h>
#include <ctype.h>
#include <assert.h>

Frame frame;
Tty tty;
int fd,in,out;

#define BUFSIZE 256 
void window2out(client,fd)
     Notify_client client;
     int fd;
{
  int result;
  char buffer[BUFSIZE];

  do {
    result = read(fd,buffer,BUFSIZE);
    if (result==0)
      {
	  /* EOF */
	  window_set(frame, FRAME_NO_CONFIRM, TRUE, 0);
	  window_done(tty);
      }
    if (result>0)
      write(out,buffer,result);
  } while (result==BUFSIZE);
}
void in2window(client,in)
     Notify_client client;
     int in;
{
  int result;
  char buffer[BUFSIZE];

  do {
    result = read(in,buffer,BUFSIZE);
    if (result==0)
      {
	  window_set(frame, FRAME_NO_CONFIRM, TRUE, 0);
	  window_done(tty);
      }
    if (result>0)
      write(fd,buffer,result);
  } while (result==BUFSIZE);
}

static void
set_rv(pw)
Pixwin *pw;
{
  static u_char red[2] = {0, -1}, green[2] = {0, -1}, blue[2] = {0 -1};
  
  pw_setcmsname(pw, "reverse-mono");
  pw_putcolormap(pw, 0, 2, red, green, blue);
}

static Notify_value
rv_on_event(client, event, arg, when)
Notify_client client;
Notify_event event;
Notify_arg arg;
Notify_event_type when;
{
  Notify_value val;
  Pixwin *pw;

  val = notify_next_event_func(client, event, arg, when);
  pw = (Pixwin *) window_get(tty, WIN_PIXWIN);
  set_rv(pw);
  return(val);
}

main(argc,argv)
     int argc;
     char *argv[];
{
  char *label;
  int wargc, rv = FALSE;
  char **wargv;
  /* Get the name */
  if (argc<2)
    label = "Hermes window.";
  else 
    label = argv[1];
  /* Get the window parameters */
  if (argc<3)
    {
      wargc = 0;
      wargv = (char **)malloc(sizeof(char *)*(wargc+1));
      wargv[wargc] = NULL;
    }
  else
    {
      char *opts = argv[2];
      int i,j,k,space;
      char buffer[256];

      j=0;
      space=1;
      for (i=0;opts[i];i++)
	{
	  if (space&&(!isspace(opts[i])))
	    j++;
	  space = isspace(opts[i]);
	}
      wargc=j;
      wargv = (char **)malloc(sizeof(char *)*(wargc+1));
      j=0;
      space=1;
      for (i=0;opts[i];i++)
	{
	  if (space&&(!isspace(opts[i])))
	    /* Entering a word */
	    k=0;
	  if (!isspace(opts[i]))
	    buffer[k++]=opts[i];
	  if (!space)
	    if (isspace(opts[i]))
	      {
		/* Leaving a word */
		buffer[k++]='\0';
		if (strcmp(buffer, "-inverse") == 0)
		  rv = TRUE;
		else {
		  wargv[j]=(char *)malloc(k);
		  strcpy(wargv[j],buffer);
		  j++;
		}
	      }
	  space = isspace(opts[i]);
	}
      if (!space)
	{
	  /* Leaving a word */
	  buffer[k++]='\0';
	  if (strcmp(buffer, "-inverse") == 0)
	    rv = TRUE;
	  else {
	    wargv[j]=(char *)malloc(k);
	    strcpy(wargv[j],buffer);
	    j++;
	  }
	}
      wargc = j;
#ifdef WINDOW_DEBUG
      fprintf(stderr,":Window passed %d args.\n",wargc);
      for (i=0;i<wargc;i++)
	fprintf(stderr,":Argument %d \"%s\"\n",i,wargv[i]);
#endif
      wargv[wargc] = NULL;
    }
  /* Create a tty subwindow */
  frame = window_create(NULL,FRAME,FRAME_LABEL,label,FRAME_ARGS,wargc,wargv,0);
  if (rv)
    window_set(frame, FRAME_INHERIT_COLORS, FALSE, 0);
  tty = window_create(frame,TTY,TTY_ARGV,TTY_ARGV_DO_NOT_FORK,0);
  if (rv) {
    Pixwin *pw;
    Cursor cur;

    pw = (Pixwin *) window_get(tty, WIN_PIXWIN);
    cur = (Cursor) window_get(tty, WIN_CURSOR);
    set_rv(pw);
    cursor_set(cur, CURSOR_OP, PIX_SRC^PIX_DST, 0);
    window_set(tty, WIN_CURSOR, cur, 0);
    notify_interpose_event_func(frame,rv_on_event,NOTIFY_SAFE);
  }
  fd = (int) window_get(tty,TTY_TTY_FD);
  /* Do it the sunview way */
  in = fileno(stdin);
  out = fileno(stdout);
  (void)fcntl(fd,F_SETFL,fcntl(fd,F_GETFL,0)|FNDELAY);
  (void)fcntl(in,F_SETFL,fcntl(in,F_GETFL,0)|FNDELAY);
  notify_set_input_func(frame,window2out,fd);
  notify_set_input_func(frame,in2window,in);
  window_main_loop(frame);
  exit(0);
}

