-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- Structures for representing named C "constructor" types (struct,
-- union, enum) and tables thereof
-- Andy Lowry & David F. Bacon, Apr 1989

-- SCCS Info: @(#)constructor.d	1.2 3/13/90

constructor: using (predefined, cType)
definitions

  -- A table in which to lookup constructor types
  constructors: table of constructor { full } keys (name);

  -- Each constructor type is associated with a name from a C
  -- specification... for example, given "struct FOO_STRUCT { ... }
  -- x;", specifications for the members of the defined structure
  -- would be stored under the name "FOO_STRUCT".  When a constructor
  -- is defined without a tag, a tag is generated and filled in here.
  constructor: record (
    name: charstring,		-- identifying tag from C specification
    type: constructorSpec	-- struct, union, or enum details
  );

  -- A constructorSpec gives all the details of the internal structure
  -- of a constructor type
  constructorSpec: variant of constructorType (
    'struct' -> struct: memberSpecs { full },
    'union' -> union: memberSpecs { full },
    'enum' -> enum: enumeratorSpecs { full }
  );

  constructorType: enumeration ( 'struct', 'enum', 'union' );

  -- A struct or union member specification includes an optional
  -- member name (omitted for placeholder field specifications), a C
  -- type ('int' for placeholders), and an optional field width
  memberSpec: record (
    name: optString,
    type: cType,
    width: optInteger
  );
  memberSpecs: ordered table of memberSpec {full};

  -- An enumerator spec gives a name for the enumerator and an
  -- optional integer value
  enumeratorSpec: record (
    name: charstring,
    value: optInteger
  );
  enumeratorSpecs: ordered table of enumeratorSpec {full};

  optString: variant of option (
    'present' -> string: charstring { init },
    'absent' -> empty: empty { }
  );

end definitions
