-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chencodings.p	1.2 3/13/92

chencodings: using(chdescriptors, chencode, chencodings, chinternal,
  chtransform, common, interpform)

process(initQ: encodingsInitQ)
  
declare
  
  initCm: encodingsInit;
  
  Q: encodingsQ;
  cm: encodings;
  
  datarep: datarepFn;
  
  top: template_operation;
  tset: template_set;
  tproc: template_procedure;
  current_program: template_operations;
  choices: integer;
  name: charstring;
  family: data_family;
  stx: integer;
  param: template_parameter;
  i: integer;
  
begin
  
  receive initCm from initQ;
  new Q;
  connect initCM.encodings to Q;
  return initCm;
  discard initQ;
  
  call (datarepsFn#(create of process(IQ: datarepsQ)
      declare
	cmi : datareps;
	Q: datarepQ;
	cm: datarep;
	names: charstringList;
	param: template_parameter;
      begin
	receive cmi from IQ;
	new Q;
	connect cmi.datarep to Q;
	return cmi;
	
	new names;
	insert "boolean" into names
	    at integer#(convert of data_family#'boolean');
	insert "enumeration" into  names
	    at integer#(convert of data_family#'enumeration');
	insert "ord_enumeration" into names
	    at integer#(convert of data_family#'ordered_enumeration');
	insert "integer" into names at
	    integer#(convert of data_family#'integer');
	insert "real" into names at integer#(convert of data_family#'real');
	insert "table" into names at integer#(convert of data_family#'string');
	insert "nominal" into names
	    at integer#(convert of data_family#'nominal');
	insert "record" into names
	    at integer#(convert of data_family#'record');
	insert "polymorph" into names
	    at integer#(convert of data_family#'polymorph');
	insert "inport" into names
	    at integer#(convert of data_family#'inport');
	insert "outport" into names
	    at integer#(convert of data_family#'outport');
	insert "callmessage" into names
	    at integer#(convert of data_family#'callmessage');
	insert "program" into names
	    at integer#(convert of data_family#'program');
	insert "variant" into names
	    at integer#(convert of data_family#'variant');
	insert "table" into names at integer#(convert of data_family#'table');
	insert "unknown" into names
	    at integer#(convert of data_family#'unknown');
	
	while 'true' repeat
	  receive cm from Q;
	  inspect op1 in cm.operands[cm.op1] begin
	    if op1.Family <> 'unknown' then
	      cm.family := op1.Family;
	    else
	      inspect op2 in cm.operands[cm.op2] begin
		cm.family := op2.Family;
	      end inspect;
	    end if;
	  end inspect;
	  
	  block begin
	    new param;
	    param.type <- 'tsdr';
	    param.string <- names[convert of cm.family];
	    insert copy of param into cm.parameters;
	    param.type <- 'tag';
	    if cm.family = 'ordered_enumeration' then
	      param.string <- "ord_enum";
	    end if;
	    insert param into cm.parameters;
	  on (DuplicateKeY)
	  end block;
	  return cm;
	end while;
      on (disconnected)
      end process))(datarep);
  
  while 'true' repeat
    receive cm from Q;
    current_program := cm.opsin;
    choices <- 0;
    inspect st in cm.env.statements[cm.env.stx] begin
      while size of cm.opsin <> 0 repeat
	remove top from cm.opsin[0];
	select case of top
	where('choice')
	  reveal top.array;
	  select cm.choose
	  where('branch') -- only one choice
	    select case of st.qualifier
	    where('integer')
	      reveal st.qualifier.integer;
	      stx := st.qualifier.integer;
	    where('select')
	      reveal st.qualifier.select;
	      stx := st.qualifier.select[cm.env.counter];
	    where('integer_pair')
	      reveal st.qualifier.integer_pair;
	      if st.opcode = 'oeloop' then
		stx := st.qualifier.integer_pair.int_one;
	      else
		stx := st.qualifier.integer_pair.int_two;
	      end if;
	    otherwise -- can't happen
	      stx <- -1;
	    end select;
	    inspect s in cm.env.statements[stx] begin
	      if s.locus = 'interpret' then
		name <- "interpret";
	      else 
		name <- "execute";
	      end if;
	    end inspect;
	  where('compare')
	    select choices
	    where(0)
	      if case of st.qualifier = 'absent' then
		name <- "assign";
	      else
		name <- "branch";
	      end if;
	    where(1)
	      call datarep(cm.env.operands,
		st.operands[1], st.operands[2],
		cm.parameters, family);
	      if family <= 'real' then
		if family = 'boolean' then
		  name <- "boolean";
		else
		  name <- "scalar";
		end if;
	      else
		name <- "other";
	      end if;
	    otherwise
	      inspect p in cm.parameters['tag'] begin
		name := p.string;
	      end inspect;
	      if name <> "unknown" then
		name <- "known";
	      end if;
	    end select;
	  where('ubiquitous')
	    if choices = 0 then
	      -- one of  copy, discard, move
	      call datarep(cm.env.operands, st.operands[0],
		st.operands[size of st.operands - 1],
		cm.parameters, family);
	      if family < 'real' then
		name <- "scalar";
	      else
		name <- "other";
	      end if;
	    else
	      -- copy only
	      inspect p in cm.parameters['tag'] begin
		name := p.string;
	      end inspect;
	      if name <> "unknown" then
		name <- "known";
	      end if;
	    end if;
	  where('select')
	    if cm.env.select_flag then
	      reveal st.qualifier.select;
	      if cm.env.counter + 1 < size of st.qualifier.select
	      then
		name <- "continue";
	      else
		name <- "finished";
	      end if;
	    else
	      if st.locus = 'block' then
		name <- "block";
	      else
		name <- "proceed";
		cm.env.select_flag <- 'true';
	      end if;
	    end if;
	  where('multiple')  -- same choice every time
	    if st.opcode = 'select' or st.opcode = 'call'
	    then i <- 1;
	      -- 'find' or 'find_or_goto'
	    else i <- 3;
	    end if;
	    if cm.env.counter + i < size of st.operands then
	      name <- "continue";
	    else
	      name <- "finished";
	    end if;
	  where('zero_test') -- only one choice
	    new param;
	    param.type <- 'value';
	    inspect op in cm.env.operands[st.operands[2]]
	    begin
	      select case of op.Literal
	      where('integer')
		reveal op.Literal.integer;
		param.string <- cm.ch.itoa(op.Literal.integer);
		if op.Literal.integer = 0 then
		  name <- "zero";
		else
		  if op.Literal.integer > 0 then
		    name <- "positive";
		  else
		    name <- "negative";
		  end if;
		end if;
		
	      where('real')
		reveal op.Literal.real;
		param.string <- cm.ch.rtoa(op.Literal.real);
		if op.Literal.real = real#(convert of integer#0)
		then
		  name <- "zero";
		else
		  if op.Literal.real >
			real#(convert of integer#0) then
		    name <- "positive";
		  else
		    name <- "negative";
		  end if;
		end if;
	      otherwise
		name <- "unknown";
		param.string <- "ch_i";	-- what of ch_r ?
	      end select;
	    end inspect;
	    block begin
	      insert param into cm.parameters;
	    on (DuplicateKeY)
	    end block;
	  otherwise
	    name <- "CHOICE";
	  end select;
	  block begin
	    remove tset from top.array[name];
	    cm.opsin <- tset.operations | cm.opsin;
	  on(NotFound)
	    unite top.string from "/*Cant choose " | name | "*/";
	    insert top into cm.opsout;
	  end block;
	  choices <- choices + 1;
	where('nest')
	  reveal top.nested;
	  dissolve top.nested into tproc;
	  call (encodingsFn#((encodingsInitFn#(create of currentprogram))()))(
	    cm.ch, cm.env, copy of tproc.choose, cm.parameters,
	    copy of tproc.operations, cm.opsout);
	where('iterate')
	  cm.env.counter <- cm.env.counter + 1;
	  cm.opsin <- current_program | cm.opsin;
	otherwise
	  insert top into cm.opsout;
	end select;
      end while;
    end inspect;
    
    return cm;
    
  end while;
  
on (disconnected)
  
end process
