chGetOptions: using (
  chinternal,load,main_options,common,annotate,initfindfile,unix,pathload,
  root,cwd,terminalIO
)
linking (chgetconfig)

process (Q: getChOptionsQ)
declare
  args: getChOptions;
  rest: charstringList;
  options: annotations;
  pathLoad: load_func;
  getCwd: getCwdFn;
  environ: environ;
  value: charstring;
  s: charstring;
  char: char;
  pos: integer;
  stdio: stdio;
  getOpt: stringOptionFn;
begin
  receive args from Q;
  
  -- get bare option strings
  unwrap pathload from args.rm.get("pathLoad", "") {init};
  call (optionsFn#(create of pathload("main_options")))
      (args.argv, "chc", args.rm, options, rest);
  args.argv <- rest;
  
  unwrap stdio from args.rm.get("stdio", "") 
      {init,init(access),init(fopen),init(tmpnam)};
  unwrap environ from args.rm.get("environ", "") {init};
  unwrap getCwd from args.rm.get("getCwd", "") {init};
  
  -- utility to return string value of an option
  getOpt <- procedure of (process (Q: stringOptionQ)
    declare
      args: stringOption;
    begin
      receive args from Q;
      block begin
	unwrap args.value from copy of args.option {init};
      on (polymorphMismatch)
	args.value <- "";
      end block;
      return args;
    end process);

  new args.options;
  -- fill in the boolean options
  args.options.verbose <- exists of options["verbose"];
  args.options.quiet <- exists of options["quiet"];
  args.options.comment <- exists of options["comment"];
  args.options.fullpaths <- exists of options["fullpaths"];
  args.options.keepC <- exists of options["keepc"];
  args.options.keepObj <- exists of options["keepobj"];
  args.options.storeC <- exists of options["storec"];
  args.options.storeobj <- not exists of options["nostoreobj"];
  args.options.transform <- not exists of options["notransform"];

  -- get function to locate .po files
  block declare
    initFF: initFindfileFn;
    load: load_func;
  begin
    inspect opt in options["load"] begin
      value <- getOpt(opt.thing);
      if value = "" then
	char <- value[0];		-- generate NotFound
	exit cantHappen;
      else
	unwrap load from args.rm.get("load", "") {init};
	initFF <- create of pathload("findfile");
	call (pathload_init_func#(create of pathload("pathload")))
	    (load, initFF(stdio.access, getCwd, value), args.options.poLoader);
      end if;
    end inspect;
  on (NotFound)				-- either no option or empty value
    args.options.poLoader := pathLoad;
  end block;

  -- figure out where to write files
  -- transformed .po files...
  block begin
    inspect opt in options["store"] begin
      value <- getOpt(opt.thing);
      if value = "" then
	char <- value[0];		-- raise NotFound
	exit cantHappen;
      else
	if value[size of value - 1] <> '/' then
	  insert '/' into value;
	end if;
	args.options.storepath <- value;
      end if;
    end inspect;
  on (NotFound)				-- no option or no value given
    args.options.storepath <- getCwd();	-- default to current directory
    insert '/' into args.options.storepath;
  end block;
  
  -- C source files...
  block begin
    inspect opt in options["storec"] begin
      value <- getOpt(opt.thing);
      if value = "" then
	args.options.storeCPath <- getCwd();-- current dir if no value given
	insert '/' into args.options.storeCPath;
      else
	if value[size of value - 1] <> '/' then
	  insert '/' into value;
	end if;
	args.options.storeCPath <- value;
      end if;
    end inspect;
  on (NotFound)
    -- no options... c files go in temporary files
    -- note following does not end in slash, so appending file names
    -- to this string will yield a uniquely named file in the /tmp
    -- directory, as desired.
    args.options.storeCPath <- stdio.tmpnam();
  end block;
  
  -- object files compiled from C sources
  if args.options.storeObj then
    block begin
      inspect opt in options["storeobj"] begin
	value <- getOpt(opt.thing);
	if value = "" then
	  -- no value specified... use first directory in HCOBJPATH if set
	  inspect entry in environ["HCOBJPATH"] begin
	    value := entry.value;
	    block begin
	      pos <- position of c in value where (c = ':');
	      value <- every of c in value where (position of c < pos);
	    on (NotFound)		-- no colon... use entire string
	    end block;
	  end inspect;
	end if;
      end inspect;
    on (NotFound)			-- either no option or no HCOBJPATH
      value <- getCwd();		-- use current dir by default
    end block;
    if value[size of value - 1] <> '/' then
      insert '/' into value;
    end if;
    args.options.storeObjPath <- value;
  else
    -- -noStoreObj was given, so objects are written to tmp files.
    -- Note that the following does not include a trailing '/', so
    -- appending a file name will result in a uniquely named file in
    -- the /tmp directory, as required.
    args.options.storeObjPath <- stdio.tmpnam();
  end if;
  
  -- break up interpreted opcode list
  new args.options.interpret;
  block begin
    inspect opt in options["interpret"] begin
      value <- getOpt(opt.thing);
      block begin
	while 'true' repeat
	  block begin
	    pos <- position of c in value where (c <> ',');
	  on (NotFound)
	    exit noMore;
	  end block;
	  extract s from c in value where (position of c < pos);
	  pos <- position of c in value where (c = ',');
	  extract s from c in value where (position of c < pos);
	  insert s into args.options.interpret;
	end while;
      on (NotFound)			-- no comma after last opcode
	insert value into args.options.interpret;
      on exit(noMore)
      end block;
    end inspect;
  on (NotFound)				-- option not given
  end block;

  -- break up debug option into individual option strings
  new args.options.debug;
  block begin
    inspect opt in options["debug"] begin
      value <- getOpt(opt.thing);
      block begin
	while 'true' repeat
	  pos <- position of c in value where (c = ',');
	  extract s from c in value where (position of c < pos);
	  block begin
	    insert s into args.options.debug;
	  on (duplicateKey)
	  end block;
	  remove char from value[];	-- skip the comma
	end while;
      on (notFound)
	-- no more commas... grab the final option
	insert value into args.options.debug;
      end block;
    end inspect;    
  on (notFound)
  end block;
  
  -- Figure out where the configuration file is
  block begin
    inspect opt in options["chconfig"] begin
      value <- getOpt(opt.thing);
    end inspect;
    if value = "" then
      char <- value[0];		-- raise notFound
      exit cantHappen;
    end if;
  on (notFound)
    -- use default of $HROOTDIR/chaux/chcode.cfg
    block begin
      inspect entry in environ["HROOTDIR"] begin
	value := entry.value;
	if value[size of value - 1] <> '/' then
	  insert '/' into value;
	end if;
	merge "chaux/chcode.cfg" into value;
      end inspect;
    on (notFound)			-- no HROOTDIR?
      -- make a wild guess
      value <- "/usr/local/hermes/chaux/chcode.cfg";
    end block;
  end block;      
  if value[0] <> '/' then
    -- relative path name... try current directory first, then default
    -- directory
    if stdio.access(getCwd() | "/" | value, 'read') then
      value <- getCwd() | "/" | value;
    else
      block declare
	rootdir: charstring;
      begin
	inspect entry in environ["HROOTDIR"] begin
	  rootdir := entry.value;
	  if rootdir[size of rootdir - 1] <> '/' then
	    insert '/' into rootdir;
	  end if;
	  if stdio.access(rootdir | value, 'read') then
	    value <- rootdir | value;
	  end if;
	end inspect;
      on (notFound)
	-- sigh... just stick with the relative path
      end block;
    end if;
  end if;
  args.options.configFile <- value;

  -- load up configuration parameters
  args.configuration <- (getChConfigurationFn#(create of process chGetConfig))
      (args.options.configFile, environ, stdio.fopen);

  -- get the command to compile C programs
  block declare
    compiler: initCompileCmdFn;
  begin
    block begin
      inspect opt in options["compilecmd"] begin
	value <- getOpt(opt.thing);
      end inspect;
    on (notFound)
      -- option not given... see if it was in the config file
      block begin
	inspect entry in args.configuration["COMPILECMD"] begin
	  unwrap value from copy of entry.thing {init};
	end inspect;
      on (notFound)
	-- not there either... make a wild guess, almost sure to be wrong
	value <- "cc -o ~O ~C";
      end block;
    end block;
    
    -- following program will instantiate command templates
    compiler <- initCompileCmdFn#(create of process (initQ: initCompileCmdQ)
      declare
	initArgs: initCompileCmd;
	Q: compileCmdQ;
	args: compileCmd;
	tstring: charstring;
	template: charstringList;
	s: charstring;
	c: char;
	pos: integer;
	tilde: boolean;
	rootdir: charstring;
	var: charstring;
	
      begin
	receive initArgs from initQ;
	tstring := initArgs.template;
	new Q;
	connect initArgs.compileCmd to Q;

	-- preprocess the string
	new template;
	new s;
	tilde <- 'false';
	while size of tstring > 0 repeat
	  remove c from tstring[];
	  if tilde then
	    select
	    where (c = '~')
	      insert '~' into s;	-- doubled tilde - treat as one
	      insert s into template;	-- make sure a literal ~x does
					-- not get interpreted
	      new s;
	    where (c = 'C' or c = 'O' or c = 'N' or c = ';')
	      insert s into template;	-- finish off this segment
	      s <- "~";
	      insert c into s;
	      insert s into template;	-- and add special entry
	      new s;
	    where (c = 'P')
	      insert s into template;	-- finish off current segment
	      block begin
		remove c from tstring[];-- get rid of open bracket
		-- extract the parameter name
		pos <- position of char in tstring where (char = ']');
		extract var from char in tstring
		    where (position of char < pos);
		remove c from tstring[];-- and eat the close bracket
		inspect entry in initArgs.configuration[var] begin
		  unwrap s from copy of entry.thing {init};
		  insert s into template;-- insert value of parameter
		end inspect;
	      on (notFound)
		-- hmm... ill-formed or no such parameter... sigh
	      end block;
	      new s;
	    where (c = 'E')
	      -- like the above, but we want an environment variable
	      insert s into template;
	      block begin
		remove c from tstring[];
		pos <- position of char in tstring where (char = ']');
		extract var from char in tstring
		    where (position of char < pos);
		remove c from tstring[];
		inspect entry in initArgs.environ[var] begin
		  insert copy of entry.value into template;
		end inspect;
	      on (notFound)
	      end block;
	      new s;
	    otherwise
	      insert c into s;
	    end select;
	    tilde <- 'false';
	  else
	    if c = '~' then
	      tilde <- 'true';
	    else
	      insert c into s;
	    end if;
	  end if;
	end while;
	if size of s > 0 then
	  insert s into template;
	end if;

	-- done with initialization
	return initArgs;
	discard initQ;

	-- now serve requests
	while 'true' repeat
	  receive args from Q;
	  new args.cmds;
	  new s;
	  for piece in template[] inspect
	    select piece
	    where ("~C")
	      merge copy of args.source into s;
	    where ("~O")
	      merge copy of args.object into s;
	    where ("~N")
	      merge copy of args.entry into s;
	    where ("~;")
	      insert s into args.cmds;
	      new s;
	    otherwise
	      merge copy of piece into s;
	    end select;
	  end for;
	  insert s into args.cmds;
	  return args;
	end while;
      on (disconnected)
      end process);

    args.options.compileCmd <- compiler(value,args.configuration,environ);
  end block;
  
  -- whew! that's everything...
  return args;
on exit(cantHappen)
end process
    
