-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_discard.p	1.1 1/21/92

chimprove_discard: using(chdescriptors, chimprove, chinternal, chtransform,
    interpform)

  process(Q: improverQ)
    
  declare
    
    cm: improver;
    
    minimum_operand_index: integer;
    
  begin
    
    minimum_operand_index <- 3;
    receive cm from Q;
    
    inspect st1 in cm.statements[cm.stx] begin
	inspect opd in cm.operands[st1.operands[0]] begin
	    if opd.Id[0] >= minimum_operand_index then
		if opd.Assignments = 0 then
		    if opd.References = 1 then
			exit drop; -- drop the discard
		      end if;
		  end if;
	      end if;
	  end inspect;
      end inspect;
    return cm;
  
  on exit(drop)
    return cm exception drop;
  end process
