-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_eliminate1.p	1.1 1/21/92

chimprove_eliminate1: using(chdescriptors, chimprove, chinternal, chtransform,
    interpform)

  process(Q: computedQ)
    
  declare
    
    cm: computed;
    
    lit: qualifier_literal;
    i: integer;
    r: real;
    
  begin
    
    receive cm from Q;
    
    inspect st1 in cm.statements[cm.stx] begin
	inspect opd in cm.operands[st1.operands[1]] begin
	    if case of opd.Literal >= 'none' then
		exit unchanged;
	      else
		select st1.opcode
		  where('not')
		    reveal opd.Literal.boolean;
		    cm.opcode <- 'boolean';
		    unite cm.qual.boolean from not opd.Literal.boolean;
		  where('inegate')
		    reveal opd.Literal.integer;
		    cm.opcode <- 'ilit';
		    unite cm.qual.integer from -opd.Literal.integer;
		  where('rnegate')
		    reveal opd.Literal.real;
		    cm.opcode <- 'rlit';
		    unite cm.qual.real from -opd.Literal.real;
		  otherwise
		    exit unchanged;
		  end select;
		return cm exception constant;
	      end if;
	  end inspect;
      end inspect;
  
  on exit(unchanged)
    return cm;
  end process
