-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)choperand.p	1.1 1/21/92

choperand: using(chdescriptors, chencode, interpform, string)

  process(Q: encode_operandQ)
    
  declare
    
    cm: encode_operand;
    construct: charstring;
    suffix: charstring;
    id: interpform!operand;
    ix: integer;
    
  begin
    receive cm from Q;
    select cm.macro
      where('ADDRESS')
	construct <- "DEF(";
	suffix <- ")";
      where('OBJECT')
	construct <- "REF(";
	suffix <- ")";
      where('VALCELL')
	construct <- "REF(";
	suffix <- ").value";
      where('TSDR')
	construct <- "REF(";
	suffix <- ").tsdr";
      where('SCALAR')
	if case of cm.operand.Literal < 'string' then
	    exit constant;
	  end if;
	block begin
	    inspect p in cm.parameters['tag'] begin
		if p.string = "real" then
		    construct <- "*REF(";
		  else
		    construct <- "REF(";
		  end if;
		suffix <- ").value." | p.string;
	      end inspect;
	  on (NotFound)
	    construct <- "REF(";
	    suffix <- ").value./*SCALAR*/";
	  end block;
      otherwise
	exit impossible;
      end select;
    id := cm.operand.id;
    remove ix from id[0];
    merge cm.ch.itoa(ix) into construct;
    for i in id[] inspect
	merge  ")DOT(" into construct;
	merge cm.ch.itoa(i) into construct;
      end for;
    merge suffix into construct;
    cm.string <- construct;
    return cm;
    
  on exit(constant)
    select case of cm.operand.Literal
      where('boolean')
	reveal cm.operand.Literal.boolean;
	if cm.operand.Literal.boolean then
	    cm.string <- "TRUE";
	  else
	    cm.string <- "FALSE";
	  end if;
      where('integer')
	reveal cm.operand.Literal.integer;
	cm.string <- cm.ch.itoa(cm.operand.Literal.integer);
      where('real')
	reveal cm.operand.Literal.real;
	cm.string <- cm.ch.rtoa(cm.operand.Literal.real);
      otherwise
	cm.string <- "/*VALUE*/";
      end select;
    return cm;
  on exit(impossible)
  end process
