-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chreferences.p	1.2 2/4/92

chreferences: using(chphase1, chtransform, interpform)

  process(Q: referencesQ)
    
  declare
    
    cm: references;
    
    summary: boolean;
    qual: interpform!qualifier;
    labels: interpform!select_qual;
    blocks: interpform!block_qual;
    handler: interpform!block_handler;
    i: integer;
    chst: ch_statement;
    
  begin
       
    receive cm from Q;

    cm.result <- 'false';

    for stix in cm.stxs[] inspect
	inspect st in cm.st[stix] begin
	    qual := st.qualifier;
	    select case of qual
	      
	      where('block')
		summary <- 'false';
		reveal qual.block;
		new blocks;
		for block_handler in qual.block[] inspect
		    handler := block_handler;
		    summary <- summary or cm.test(cm.st, handler.label);
		    insert handler into blocks;
		  end for;
		qual.block <- blocks;
		    
	      where('integer')
		reveal qual.integer;
		call cm.test(cm.st, qual.integer, summary);
		
	      where('integer_pair')
		reveal qual.integer_pair;
		if st.opcode = 'oeloop' then
		    call cm.test(cm.st, qual.integer_pair.int_one, summary);
		  else
		    call cm.test(cm.st, qual.integer_pair.int_two, summary);
		  end if;
		
	      otherwise
		summary <- 'false';
		reveal qual.select;
		new labels;
		for label in qual.select[] inspect
		    i := label;
		    summary <- summary or cm.test(cm.st, i);
		    insert i into labels;
		  end for;
		qual.select <- labels;
		   
	      end select;
	    
	    if summary then
		remove chst from cm.st[stix];
		chst.qualifier <- qual;
		insert chst into cm.st at stix;
		cm.result <- 'true';
	      end if;
	    
	  end inspect;
	
      end for;
    
    return cm;
    
  end process

