-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cginit.d
-- Author: Andy Lowry
-- SCCS Info: @(#)cginit.d	1.18 2/14/92

-- This is the interface to the cgInit function, which collects
-- together a few important objects and returns them in a cgData
-- structure.  cgInit initializes everything except Prog, options and
-- Proc components of cgData.  Pass capabilities to procedures that
-- can load compiled programs and arbitrary objects from disk.

-- Also included in this module are init interfaces for processes that
-- act as servers.  They are in this module instead of cgInternal
-- because only cgInit and the process module that defines the server
-- need the definitions.

cgInit: using (common, cgInternal, objectIO, load)

definitions

  cgInit: callmessage (
    pathLoad: load_func,	-- for loading Hermes programs
    loadobj: readobject_func,	-- for loading the opcode map
    finish: signalPort,		-- use this to shut down server procs
				-- started by cgInit
    cgData: cgData		-- the record we're filling in
  )
  constant (pathLoad,loadobj)
  exit {init(pathLoad), init(loadobj), init(finish), init(cgData),
    full(cgData.Prog), init(cgData.options), full(cgData.Aux),
    full(cgData.Fns), full(cgData.Tplt), full(cgData.scratch)}
  minimum {init(pathLoad), init(loadobj), init(cgData), full(cgData.Prog),
    full(cgData.options)};
  cgInitQ: inport of cgInit {init(pathLoad), init(loadobj), init(cgData),
    full(cgData.Prog), init(cgData.options)};
  cgInitFn: outport of cgInitQ;

  -- Init interfaces for server processes started by cgInit... In
  -- general, each interface just returns a one or more server
  -- capabilities and a shutdown signal port.  Sending a message on
  -- the shutdown port should cause the server to terminate.

  cgStmtInit: callmessage (
    cgStmt: cgStmtFn,		-- capability for service fn
    shutdown: signalPort	-- capability to kill the server
  )
  exit {full};
  cgStmtInitQ: inport of cgStmtInit {};
  cgStmtInitFn: outport of cgStmtInitQ;
  
  typeDefInit: callmessage (
    progData: cgProgData,	-- from the original codegen input
    typeDef: typeDefFn,		-- capability for service fn
    shutdown: signalPort	-- capability to kill the server
  )
  constant (progData)
  exit {full};
  typeDefInitQ: inport of typeDefInit {full(progData)};
  typeDefInitFn: outport of typeDefInitQ;

  compOffsetsInit: callmessage (
    progData: cgProgData,	-- from the original codegen input
    typeDef: typeDefFn,		-- capa to the typeDef process
    compOffsets: compOffsetsFn,	-- capability for services fn
    shutdown: signalPort	-- capability to kill the server
  )
  constant (progData, typeDef)
  exit {full};
  compOffsetsInitQ: inport of compOffsetsInit {full(progData), init(typeDef)};
  compOffsetsInitFn: outport of compOffsetsInitQ;

end definitions
