/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: Andy Lowry */
/* SCCS Info: @(#)Makefile	1.26 2/7/92 */

/* This makefile builds all the files that are shared by at least two */
/* phases of the codegen build procedure.  This includes compiled */
/* definitions modules (.do files) and other assorted things. */

/* Set the default target here at the top so there's no confusion... */
all:

/* Objects to be built */
DEFOBJS =	cginternal.do cginit.do bbassemble.do exprtree.do \
		cgstmt.do objaddr.do compoffsets.do
PROCOBJS =	makeopmap.po

/* Get standard system definitions */
#include "includefile"

/* Set GENHROOT to something other than the default hermes root path in */
/* order to import GENHROOT's definitions but use the normal compiler */
GENHROOT =	$(HROOT)
GENBIN =	$(GENHROOT)/bin

/* Load files from here, and then from alternate system directory */
DEFPATH	=	.:$(GENBIN)

/* Override normal suffix rule, since for bootstrapping we need to run  */
/* the standalone front-end on each definitions module individually */
.d.do:	$<
	$(STANDALONE) $*$(DEFSUFFIX)
/* Normally we define STANDALONE and DEFSUFFIX as empty so they render the  */
/* above suffix rule identical to the standard case */
STANDALONE =
DEFSUFFIX =

/* Source files needed for build...  */
DFILES	=	cginternal.d cginit.d bbassemble.d exprtree.d \
		cgstmt.d objaddr.d compoffsets.d
PPFILES =	makeopmap.pp
SOURCES = 	$(DFILES) $(PPFILES)

/* .p files genereated from .pp files by cpp */
PFILES =	makeopmap.p
/* default target builds all the object files and the opcode map */
all:		$(SOURCES) $(PFILES) compiledefs compileprocs opmap.obj

/* see interface/Makefile for a description of the following bogosity */
fixdefs:
	@-rm -rf .dosave 2>/dev/null
	@mkdir .dosave
	@mv *.do .dosave
	@dlist=`make -n defobjs` ; echo $$dlist > .dlist
	@mv .dosave/?* .
	@rmdir .dosave
	@dlist=`cat .dlist` ; rm .dlist ; \
		echo $(ENV) $(HERMENV) $(HERMES) fixdefs $$dlist ; \
		$(ENV) $(HERMENV) $(HERMES) fixdefs $$dlist

/* Following target only builds the .do files... use this as the first */
/* step in bootstrapping from generated LI sources */
dofiles:	$(DFILES) compiledefs

/* Following target builds .do files using the standalone front-end */
boot-dofiles:
	$(MAKE) $(DEFOBJS) HROOT=$(HROOT) GENHROOT=$(GENHROOT) MTYPE=$(MTYPE) \
	STANDALONE="$(ENV) HROOTDIR=$(GENHROOT) HPATH=$(DEFPATH) $(HPARSE)" \
	DEFSUFFIX=".d"

/* Here are the rules for making the opcode map table */
opmap.obj:	makeopmap.po
	$(ENV) HROOTDIR=$(HROOT) HLOADPATH=.:$(LOADPATH) $(HERMES) makeopmap
makeopmap.p:	makeopmap.pp

/* Create links to source files from the codegen root directory */
$(SOURCES):
	@ if [ ! -f $@ ] ; then ln -s $(HROOT)/codegen/$@ . ; fi

/* dependencies among definitions modules */
cginternal.do: cginternal.d
cginit.do: cginit.d cginternal.do
bbassemble.do: bbassemble.d cginternal.do
cgstmt.do: cgstmt.d cginternal.do
objaddr.do: objaddr.d cginternal.do


/* 'make clean' silently discards all files generated by this makefile */
clean::
	rm -f opmap.obj $(SOURCES)
	rm -f `echo "$(PPFILES) " | sed "s/\.pp /.p /g"` 2>/dev/null
