-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: exprtree.d
-- Author: Andy Lowry
-- SCCS Info: @(#)exprtree.d	1.3 3/13/90

-- A representations for the statements (other than coercions) in a
-- clause defining a Hermes expression.  The tree representation
-- simplifies analysis of the expression by making all dependencies
-- explicit.

exprTree: using ()
definitions
  
  -- An expression is represented either as an object name (a leaf) or
  -- as a tree, with each node representing one of the statements used
  -- in constructing the tree
  exprType: enumeration ('object', 'tree');
  expr: variant of exprType (
    'object' -> obj: predefined!objectname {full},
    'tree' -> tree: exprTree {full}
  );
  exprList: ordered table of expr {init};
  -- A node in the expression tree includes a Hermes opcode, a
  -- statement qualifier, a destination objectname, and zero or more
  -- source operands which are themselves of type 'expr'
  exprTree: record (
    opcode: predefined!operator,
    qual: predefined!qualifier,
    dst: predefined!objectname,
    args: exprList,
    prag: charstring
  );
  
  -- A collection of exprTree records (not expr's in the 'tree' case)
  exprTrees: ordered table of exprTree {full};

  -- Interface to the makeExpr process, which converts the statement
  -- list from an expression clause into an expr structure.  RESULT is
  -- the object for which an expression needs to be built
  makeExpr: callmessage (
      result: predefined!objectname,
      stmts: predefined!statements,
      expr: expr
    )
    constant (result, stmts)
    exit {full};
  makeExprQ: inport of makeExpr {full(result), init(stmts)};
  makeExprFn: outport of makeExprQ;

  -- Interface to the exprAssemble process, which converts an expr
  -- structure into a list of statements that will compute the
  -- expression.
  exprAssemble: callmessage (
      expr: expr,
      stmts: predefined!statements
    )
    constant (expr)
    exit {full};
  exprAssembleQ: inport of exprAssemble {full(expr)};
  exprAssembleFn: outport of exprAssembleQ;

  -- Interface to the exprUsesObj process, which checks whether a
  -- given object is referenced within a given expr structure.
  exprUsesRoot: callmessage (
      expr: expr,
      root: predefined!rootname,
      used: boolean
    )
    constant (expr, root)
    exit {full};
  exprUsesRootQ: inport of exprUsesRoot {full(expr), full(root)};
  exprUsesRootFn: outport of exprUsesRootQ;  

end definitions
