/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile.libuild */
/* Author: Andy Lowry */
/* SCCS Info: @(#)Makefile	1.22 2/7/92 */

/* Makefile to build the Hermes code generator from LI assembler */
/* sources that were generated from the Hermes sources. */

/* Set the default target here at the top so there's no confusion... */
all:

/* Get standard stuff */
#include "includefile"

/* Can't use '.' in paths at this point in boot sequence, since we */
/* don't yet have a working cwd module */
LOADPATH =	$(HROOT)/codegen/p1:$(PROCDIR)

/* Generated source files */
LIFILES =	codegen.li cginit.li cgprocess.li cgprocinit.li \
			cgclause.li cgstmt.li cgdirectstmt.li \
			cgtypedstmt.li cgstmtstub.li cgblock.li \
			cgif.li cgwhile.li cgevery.li cgexists.li \
			cgextract.li cgforinsp.li cginsptbl.li \
			cgremove.li cgforall.li cgposition.li cgposofelt.li \
			cgtheelement.li cgselect.li cgexprblock.li \
			cgnamedlit.li cgconvert.li cgcase.li \
			cgforenum.li cginsppoly.li cgnew.li \
			cgselector.li breakselector.li newtableinfo.li \
			bbassemble.li objaddr.li objalias.li optimize.li \
			cgatoi.li lkuptype.li typedef.li compoffsets.li \
			varcaseid.li clauseusesobj.li makeopmap.li cgator.li
GENFILES =	$(LIFILES)
/* Files needed from the common build directory... */
DOFILES	=	cginternal.do cginit.do \
		bbassemble.do objaddr.do compoffsets.do \
		exprtree.do cgstmt.do
DOFILESZ =	cginternal.do.Z cginit.do.Z \
		bbassemble.do.Z objaddr.do.Z compoffsets.do.Z \
		exprtree.do.Z cgstmt.do.Z
COMMFILES =	$(DOFILES)
COMMFILESZ = $(DOFILESZ)

/* Object files produced from the build */
PROCOBJS =	codegen.po cginit.po cgprocess.po cgprocinit.po \
		cgclause.po cgstmt.po cgdirectstmt.po \
		cgtypedstmt.po cgstmtstub.po cgblock.po \
		cgif.po cgwhile.po cgevery.po cgexists.po \
		cgextract.po cgforinsp.po cginsptbl.po \
		cgremove.po cgforall.po cgposition.po cgposofelt.po \
		cgtheelement.po cgselect.po cgexprblock.po \
		cgnamedlit.po cgconvert.po cgcase.po \
		cgforenum.po cginsppoly.po cgnew.po \
		cgselector.po breakselector.po newtableinfo.po \
		bbassemble.po objaddr.po objalias.po optimize.po \
		cgatoi.po lkuptype.po typedef.po compoffsets.po \
		varcaseid.po clauseusesobj.po \
		cgator.po
PROCOBJSZ =	codegen.po.Z cginit.po.Z cgprocess.po.Z cgprocinit.po.Z \
		cgclause.po.Z cgstmt.po.Z cgdirectstmt.po.Z \
		cgtypedstmt.po.Z cgstmtstub.po.Z cgblock.po.Z \
		cgif.po.Z cgwhile.po.Z cgevery.po.Z cgexists.po.Z \
		cgextract.po.Z cgforinsp.po.Z cginsptbl.po.Z \
		cgremove.po.Z cgforall.po.Z cgposition.po.Z cgposofelt.po.Z \
		cgtheelement.po.Z cgselect.po.Z cgexprblock.po.Z \
		cgnamedlit.po.Z cgconvert.po.Z cgcase.po.Z \
		cgforenum.po.Z cginsppoly.po.Z cgnew.po.Z \
		cgselector.po.Z breakselector.po.Z newtableinfo.po.Z \
		bbassemble.po.Z objaddr.po.Z objalias.po.Z optimize.po.Z \
		cgatoi.po.Z lkuptype.po.Z typedef.po.Z compoffsets.po.Z \
		varcaseid.po.Z clauseusesobj.po.Z \
		cgator.po.Z
COMMOBJS =	$(HROOT)/codegen/com/opmap.obj
COMMOBJSZ =	$(HROOT)/codegen/com/opmap.obj.Z
OTHEROBJ =	opmap.obj
OTHEROBJZ =	opmap.obj.Z
OBJECTS =	$(PROCOBJS)  $(OTHEROBJ) $(COMMOBJS)
OBJECTSZ =	$(PROCOBJSZ)  $(OTHEROBJZ) $(COMMOBJSZ)

/* default target builds all the object files */
all:	$(OBJECTS)
install: all
	cp $(PROCOBJS) $(PROCDIR)
	cp $(OTHEROBJ) $(DEFDIR)

uninstall:
	( cd $(PROCDIR) ; rm -f $(PROCOBJS) )

/* Just the object files for the common directory */
commobj:	$(COMMOBJS)

/* opmap.obj in the common directory is made by creating a local */
/* copy in the work directory and then copying it */
$(HROOT)/codegen/com/opmap.obj: opmap.obj
	cp opmap.obj $(HROOT)/codegen/com

/* Explicit dependencies for assembling automatically generated .li files */
codegen.po:	codegen.li cginit.do
cginit.po:	cginit.li cgstmt.do cginit.do
cgprocess.po:	cgprocess.li 
cgprocinit.po:	cgprocinit.li 
cgclause.po:	cgclause.li 
cgstmt.po:	cgstmt.li cgstmt.do cginit.do
cgdirectstmt.po: cgdirectstmt.li cginit.do
cgtypedstmt.po:	cgtypedstmt.li cginit.do
cgstmtstub.po:	cgstmtstub.li 
cgevery.po:	cgevery.li 
cgexists.po:	cgexists.li 
cgextract.po:	cgextract.li 
cgforinsp.po:	cgforinsp.li 
cginsptbl.po:	cginsptbl.li 
cgposition.po:	cgposition.li 
cgposofelt.po:	cgposofelt.li 
cgremove.po:	cgremove.li 
cgforall.po:	cgforall.li 
cgtheelement.po: cgtheelement.li 
cgselect.po:	cgselect.li 
cgexprblock.po:	cgexprblock.li 
cgnamedlit.po:	cgnamedlit.li 
cgconvert.po:	cgconvert.li 
cgforenum.po:	cgforenum.li 
cginsppoly.po:	cginsppoly.li 
cgblock.po:	cgblock.li 
cgif.po:	cgif.li 
cgwhile.po:	cgwhile.li 
cgcase.po:	cgcase.li
cgnew.po:	cgnew.li 
cgselector.po:	cgselector.li 
breakselector.po: breakselector.li  exprtree.do
newtableinfo.po: newtableinfo.li 
bbassemble.po:	bbassemble.li  bbassemble.do
objaddr.po:	objaddr.li  objaddr.do objalias.po
objalias.po:	objalias.li 
optimize.po:	optimize.li 
cgatoi.po:	cgatoi.li 
lkuptype.po:	lkuptype.li 
typedef.po:	typedef.li
compoffsets.po:	compoffsets.li compoffsets.do
varcaseid.po:	varcaseid.li 
clauseusesobj.po: clauseusesobj.li 
makeopmap.po:	makeopmap.li 
cgator.po:	cgator.li 

$(PROCOBJS): cginternal.do

/* Generate the opcode map */
opmap.obj:	makeopmap.po
	$(ENV) $(HERMENV) $(HERMES) makeopmap

/* Get links to missing files from the main source directory, the ligen */
/* directory, and the common directory */
$(GENFILES):
	@ if [ ! -f $@ ] ; then ln -s $(HROOT)/codegen/li/$@ . ; fi
$(COMMFILES):
	@ if [ ! -f $@ ] ; then ln -s $(HROOT)/codegen/com/$@ . ; fi
    

/* Extra suffix rules we need */

.SUFFIXES: .vars .vh .lipp 

.lipp.li: $<
	$(CPP) $(HCPPFLAGS) $< $@

.li.po: $<
	$(ENV) HROOTDIR=$(HROOT) HPATH=$(DEFPATH) $(ASM) $<

.vars.vh: $<
	awk -f vars.awk $< >$@

clean::
	rm -f $(OTHEROBJ) $(OTHEROBJZ) *.li *.vh *.cd
	rm -f $(GENFILES) 2>/dev/null
