-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: regmap.d
-- Author: Andy Lowry
-- SCCS Info: @(#)regmap.d	1.2 3/13/90

-- Info to map registers to rootnames in LI code.  Since register
-- assignments can change from one point in the code to another, each
-- register is mapped to a table of assignments, each covering a
-- particular range of code.  Note that overlapping ranges ARE
-- ALLOWED, since a single register might be used for multiple root
-- objects due to compiler aliasing.

regMap: using (interpform, cgInternal)

definitions
  
  regMap: table of regMapEntry {full} keys (reg);
  regMapEntry: record (
    reg: integer,		-- register number
    asgns: regAssignments	-- how the reg is is used
  );
  regAssignments: table of regAssignment {full};
  regAssignment: record (
    from: integer,		-- range of affected instruction addresses
    upto /* but not including */ : integer,
    obj: predefined!rootname	-- an object held in the register
  );
  
  -- A table of regMaps to go with a collection of basic blocks...
  -- instruction address ranges are relative to the basic block
  -- itself, not the entire program code.
  BBRegMaps: table of BBRegMap {full} keys (id);
  BBRegMap: record (
    id: BBid,
    map: regMap
  );

end definitions

