/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)chgram.yacc	1.3 3/13/90 */

/*
 * fegram.yacc
 * 
 * yacc grammar for Hermes
 *
 */

%{
#include <stdio.h>

#include "li.h"

#include "resolve.h"
#include "resfuncs.h"

#undef TRUE
#undef FALSE
#undef CALLMESSAGE
#undef INITPORT

#define True -1
#define False 0

char *downcase();
char *copystring();

extern char yytext[];

static int compnum;
char typename[128];
static flag record;
int enumval;

%}

%union {
	char *string; 
	}

%type <string> identifier named_literal




/*
 * token definitions are prepared automatically from the files "keywords" and
 * "othertokens".  we Include them here with m4.
 */

include(tokens.yacc)


/*
 * start symbol -- a module
 */

%start module

%%

/*TEXBEGIN*/

/*--------------------------------------------------------------------------*/
/*------------------------------- MODULES ----------------------------------*/
/*--------------------------------------------------------------------------*/

/* GOAL SYMBOL */
module : module_name ':' 
	
	direct_imports module_body 
	 ;

module_body : process_module ;
module_body : definitions_module ;

direct_imports : USING module_name_list ;

/*--------------------------------------------------------------------------*/
/*--------------------------- Common Productions ---------------------------*/
/*--------------------------------------------------------------------------*/

pragma : PRAGMA string_literal 
	 ;

empty : ;

/*--------------------------------------------------------------------------*/
/*------------------------------ NAMES -------------------------------------*/
/*--------------------------------------------------------------------------*/

type_name : qualified_name 
	 ;

attribute_name : qualified_name 
	 ;

object_name : root_object_name 
	
	component_s
	 ;

root_object_name : identifier
	 ;

component : '.' component_name
	 ;

component_name : identifier 
	 ;

formal_object_name : '*'
	 ;
formal_object_name : component_name
	component_s
	 ;

module_name : identifier 
	 ;

exception_name : type_name '.' identifier ;
exception_name : identifier ;

qualified_name : identifier '!' identifier 
	 ;
qualified_name : identifier 
	 ;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*------------------------- DEFINITIONS MODULE -----------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

definitions_module : DEFINITIONS 
	
        definition_series END DEFINITIONS
	 ;

definition : identifier ':' 
	{ record = False; strcpy(typename, $1); }	
	construction ;

definition : identifier ':' 
	{ record = False; strcpy(typename, $1); }
	pragma construction ;

construction : type_construction ;
construction : attribute_construction ;

/*--------------------------------------------------------------------------*/
/*--------------------------- Type Definitions -----------------------------*/
/*--------------------------------------------------------------------------*/

/*------------------------------- Scalars ----------------------------------*/

type_construction : NOMINAL
	 ;

type_construction : INTEGER
	 ;

type_construction : REAL OF ACCURACY integer_literal '/' integer_literal 
	 ;

type_construction : opt_ordered ENUMERATION
	{ enumval = 0; }
	named_literal_list 
	{ printf("#define %s__Size %d\n", typename, enumval); }
	;

ordered : ORDERED ;

type_construction : BOOLEAN '(' boolean_association ')' ;

boolean_association : boolean_true ',' boolean_false 
	;
boolean_association : boolean_false ',' boolean_true 
	;

boolean_true : TRUE ':' named_literal 
	 ;

boolean_false : FALSE ':' named_literal
	 ;

/*--------------------------------- Records --------------------------------*/

type_construction : RECORD
	{ record = True; compnum = 0; }	
	declaration_list 
	{ printf("#define %s__Size %d\n", typename, compnum); }
	 ;

/*------------------------------- Variants ---------------------------------*/

type_construction : VARIANT OF type_name 
	 
	case_declaration_list 
	 ;

/* the resolution environment for the formal typestate is the definition */
/*   of the declared component. */

case_declaration : named_literal names_case declaration
	
	formal_typestate 
	;

/*--------------------------------- Tables ---------------------------------*/

/* the resolution environment for the formal typestate and the formal object */
/*   names is the definition of the named type. */

type_construction : opt_ordered TABLE OF type_name 
	formal_typestate opt_key_definition 
	 ;

key_definition : KEYS
	
	formal_object_name_list_s
	 ;

/*-------------------------------- Ports -----------------------------------*/

type_construction : OUTPORT OF type_name 
	 ;

/* the resolution environment for the formal typestate is the definition of */
/*   the named type. */

type_construction : INPORT OF type_name
	
	formal_typestate 
	 ;

/*----------------------------- Callmessages -------------------------------*/

/* resolution environment for the formal typestates is the callmessage def */

type_construction : CALLMESSAGE
	{ record = True; compnum = 0; }		
	declaration_list /*3*/
	
	opt_constant_parameters /*5*/
	EXIT formal_typestate /*7*/
	opt_minimum_typestate /*8*/
	callmessage_exception_s 
	 ;	/* user exceptions? */

constant_parameters : CONSTANT component_name_list 
	 ;

minimum_typestate : MINIMUM formal_typestate 
	 ;

callmessage_exception : EXCEPTION identifier formal_typestate
	 ;

/*--------------------------------------------------------------------------*/
/*--------------------------- Attribute Definitions ------------------------*/
/*--------------------------------------------------------------------------*/

attribute_construction : CONSTRAINT declaration_list
	IS typestate expression ;

/*--------------------------------------------------------------------------*/
/*---------------------- Typestate Specifications --------------------------*/
/*--------------------------------------------------------------------------*/

typestate : '{'
	attribute_set '}' ;

attribute_set : attribute_set1 ;
attribute_set : empty ;

attribute_set1 : attribute ;
attribute_set1 : attribute_set1 ',' attribute ;

attribute : attribute_name object_association ;

object_association : object_name_list ;
object_association : object_pair_semilist ;

object_pair : identifier ':' object_name ;

object_pair_semilist : '(' object_pair_semilist2 ')' ;
object_pair_semilist2 : object_pair_semilist2 ',' object_pair ;
object_pair_semilist2 : object_pair ;

/* formal typestates */

formal_typestate : '{' 
	
	formal_attribute_set '}' 
	 ;

formal_attribute_set : formal_attribute_set1 ;
formal_attribute_set : empty ;

formal_attribute_set1 : formal_attribute_set1 ',' formal_attribute 
	 ;
formal_attribute_set1 : formal_attribute
	 ;

formal_attribute : attribute_name formal_association 
	 ;

formal_association : empty 
	 ;
formal_association : formal_object_name_list
	 ;
/*
formal_association : formal_object_pair_semilist
	 ;

formal_object_pair_semilist : '(' formal_object_pair_semilist2 ')' ;

formal_object_pair_semilist2 : formal_object_pair ;
formal_object_pair_semilist2 : formal_object_pair_semilist2 ',' 
	formal_object_pair ;

formal_object_pair : identifier ':' formal_object_name ;
*/

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*------------------------------ PROCESS MODULES ---------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

process_module : PROCESS  '(' declaration ')' opt_pragma 
	
	block_body END PROCESS
	 ;

/*--------------------------------------------------------------------------*/
/*------------------------------- Declarations -----------------------------*/
/*--------------------------------------------------------------------------*/

declaration : identifier ':' type_name 
	{ if (record) {
	    printf("#define %s__%s %d\n", typename, $1, compnum);
	    compnum++;
	  };
	} ;

declaration : identifier ':' pragma type_name 
	{ if (record) {
	    printf("#define %s__%s %d\n", typename, $1, compnum);
	    compnum++;
	  };
	}
	 ;

/*--------------------------------------------------------------------------*/
/*-------------------------------- Blocks ----------------------------------*/
/*--------------------------------------------------------------------------*/

compound_statement : BLOCK 
	
	block_body END BLOCK
	 ;

block_body : opt_constant_section
               opt_declaration_section
               BEGIN statement_series
               handler_s ;

declaration_section : DECLARE declaration_series ;

constant_section : CONSTANT root_object_name_list ;

handler : ON exception_name_list statement_series ;
handler : ON EXIT identifier_list statement_series ;

/*--------------------------------------------------------------------------*/
/*------------------------------ Statements --------------------------------*/
/*--------------------------------------------------------------------------*/

statement : simple_statement ;
statement : pragma simple_statement ;
statement : compound_statement ;
statement : pragma compound_statement ;

/*--------------------------------------------------------------------------*/
/*--------------------------- Compound Statements --------------------------*/
/*--------------------------------------------------------------------------*/

/*---------------------------- IF Statement --------------------------------*/

compound_statement : IF expression
                   THEN statement_series
                   opt_else_clause
                   END IF ;

else_clause : ELSE statement_series ;

/*-------------------------- SELECT Statement ------------------------------*/

compound_statement : SELECT opt_expression
                       select_clause_s
                       otherwise_clause
                       END SELECT ;

select_clause : where_guard statement_series ;
select_clause : event_guard statement_series ;
select_clause : event_guard AND where_guard
                  statement_series ;

event_guard : EVENT object_name ;

where_guard : WHERE '(' expression ')' ;

otherwise_clause : OTHERWISE statement_series ;

/*-------------------- inspect block (not in v0) ----------------------------*/

compound_statement : INSPECT inspect_object 
	BEGIN statement_series END INSPECT ;

inspect_object : selector ;

/* inspect_object : identifier FROM object_name formal_typestate ; */
inspect_object : declaration FROM object_name formal_typestate ;

/*-------------------------- Iterative Statements ---------------------------*/

compound_statement : WHILE 
	
	expression REPEAT
	
	statement_series END WHILE
	 ;

compound_statement : FOR selector
	
	INSPECT statement_series END FOR
	 ;

compound_statement : FOR declaration
	
	REPEAT statement_series END FOR
	 ;

/*--------------------------------------------------------------------------*/
/*------------------------- Simple Statements ------------------------------*/
/*--------------------------------------------------------------------------*/

/*-------------------- compiler debugging ----------------------------------*/

simple_statement : PRINT object_name
	 ;

/*----------------------------- Move and Copy ------------------------------*/

simple_statement : object_name move expression
	 ;

simple_statement : object_name assign expression
	 ;

/*--------------------- Making new, and discarding old -------------------*/

simple_statement : NEW object_name 
	 ;

simple_statement : DISCARD object_name
	 ;

/*---------------------------- Variants ------------------------------------*/

simple_statement : UNITE object_name FROM expression
	 ;

simple_statement : DISSOLVE object_name INTO object_name
	 ;

simple_statement : REVEAL object_name
	 ;

simple_statement : HIDE object_name 
	 ;

/*---------------------------- Tables --------------------------------------*/

simple_statement : INSERT expression INTO object_name opt_position ;

simple_statement : MERGE expression INTO object_name opt_position ;

position : AT '(' expression ')'
	 ;

simple_statement : REMOVE object_name FROM selector
	 ;

simple_statement : EXTRACT object_name FROM selector
	 ;

selector : identifier IN object_name
	
	WHERE '(' expression ')'
	 ;

/*-------------------------------- Communications --------------------------*/

simple_statement : CALL primary association ;

/* in a connect, the outport is the "destination */
simple_statement : CONNECT object_name TO object_name
	 ;
	
association : expression_list ;
/* this isn't a _list, since if it were it would cause an */
/*   ambiguity -- both could generate the empty list "()" */
association : associated_pair_semilist ;

associated_pair : identifier ':' expression ;

simple_statement : RETURN object_name opt_return_exception ;

return_exception : EXCEPTION identifier ;

simple_statement : RECEIVE object_name FROM object_name
	 ;

simple_statement : SEND expression TO expression 
	 ;

/*--------------------------------- Packages -------------------------------*/

simple_statement : WRAP object_name AS object_name
	 ;

simple_statement : UNWRAP object_name FROM object_name formal_typestate ;

/*------------------------ Typestate Changing Statements -------------------*/

simple_statement : DROP attribute ;

simple_statement : ASSERT attribute ;

/*---------------------------- Transfer of Control -------------------------*/

simple_statement : EXIT identifier ;

simple_statement : CHECKDEFINITIONS object_name
	 ;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*------------------------------ Expressions -------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

expression : type_specifier disjunction	/* and here? fix later */
	 ;
expression : disjunction
	 ;

type_specifier : type_name '#' ;

disjunction : conjunction
	 ;
disjunction : disjunction OR conjunction
	 ;

conjunction : relation
	 ;
conjunction : conjunction AND relation
	 ;

relation : concat
	 ;
relation : concat '=' concat
	 ;
relation : concat '<' concat
	 ;
relation : concat '>' concat
	 ;
relation : concat nequal concat
	 ;
relation : concat lequal concat
	 ;
relation : concat gequal concat
	 ;

concat : term
	 ;
concat : concat '|' term
	 ;

term   : factor
	 ;
term   : '-' factor
	 ;
term   : term '+' factor
	 ;
term   : term '-' factor
	 ;

factor : secondary 
	 ;
factor : factor '*' secondary
	 ;
factor : factor '/' secondary
	 ;
factor : factor MOD secondary
	 ;
factor : factor REM secondary
	 ;

/*--------------------------------------------------------------------------*/
/*------------------------------ Secondaries -------------------------------*/
/*--------------------------------------------------------------------------*/

secondary : primary
	 ;

secondary : COPY OF secondary
	 ;

secondary : CONVERT OF secondary
	 ;

secondary : CASE OF secondary
	 ;

secondary : NOT secondary
	 ;

/*---------------------------------- Tables --------------------------------*/

secondary : SIZE OF secondary
	 ;

secondary : EXISTS OF selector
	 ;

secondary : FORALL OF selector
	 ;

secondary : EVERY OF selector
	 ;

secondary : selector
	 ;

secondary : POSITION OF object_name
	 ;
secondary : POSITION OF selector
	 ;

/*---------------------------------- Ports ---------------------------------*/

secondary : EMPTY OF secondary
	 ;

/*-------------------------- The Expression Block --------------------------*/

secondary : EVALUATE declaration FROM statement_series END
	 ;

secondary : CREATE OF secondary
	 ;

secondary : PROCEDURE OF secondary
	 ;

secondary : TYPE OF secondary
	 ;

secondary : TYPESTATE OF secondary
	 ;

/* should these be primaries? */

secondary : UNIQUE
	 ;

secondary : CURRENTPROGRAM
	 ;

/*--------------------------------------------------------------------------*/
/*------------------------------ Primaries ---------------------------------*/
/*--------------------------------------------------------------------------*/

primary : object_name
	 ;
primary : literal
	 ;
primary : '(' expression ')'
	 ;
primary : function_reference
	 ;

function_reference : primary association
	 ;

/*---------------------------------- Literals ------------------------------*/

literal : integer_literal
	 ;
literal : real_literal
	 ;
literal : named_literal
	 ;
literal : string_literal
	 ;
literal : program_literal
	 ;
literal : absprog_literal
	 ;

program_literal : PROCESS '(' declaration ')' opt_pragma block_body END PROCESS ;

absprog_literal : '\\' TYPENAME type_name '\\' 
	;

/*TEXEND*/

/* this isn't really a _list.  It can't be empty, since this would cause */
/* an ambiguity. */

associated_pair_semilist : '(' associated_pair_l2 ')' ;
associated_pair_l2 : associated_pair ;
associated_pair_l2 : associated_pair_l2 ',' associated_pair ;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*---------------------------- Error Handling ------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

simple_statement : error ';' ;

construction : error ';' ; 

declaration : error ';' 
	 ;  /* fix later */

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*----------------------------- UGLY ---------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* Here come the parts of the grammar not fit for human consumption */

names_case : T_NAMESCASE ;
move : T_MOVE ;
assign : T_ASSIGN ;
nequal : T_NEQUAL ;
lequal : T_LEQUAL ;
gequal : T_GEQUAL ;

real_literal : T_REAL 
	 ;

integer_literal : T_INTEGER 
	 ;

string_literal : T_STRING
	 ;

named_literal : T_NAME
	{ $$ = copystring(yytext); } ;


/* include automatically generated productions */

include(chlist.yacc)
include(chkleene.yacc)
include(chseries.yacc)
include(chopt.yacc)


/*
 * identifier -- an identifier is either a symbol or a non-reserved keyword.
 * the production is produces automatically from the files "keywords" and
 * "reswords", and Included with m4
 */

include(ident.yacc)

%%
