/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)chmain.c	1.3 8/28/91 */

#include <stdio.h>
#include "stdnil.h"
#include "lex-yacc.h"


#define YYBUFSIZE 256

char yytext[YYBUFSIZE];

char *filename;

main(argc, argv)
int argc;
char *argv[];
{
    int retcode;


    if (argc > 1) {
	freopen(argv[1], "r", stdin);
	if (stdin is NULL) {
	    fprintf(stderr, "Couldn't open %s\n", argv[1]);
	    exit(1);
	}
	filename = argv[1];
    }
    else 
      filename = nil;

    lexinit();

    retcode = yyparse(); /* do it up!!!!! */

    if (retcode) 
      printf("Error detected.\n");
    exit(retcode);
}


void
yyerror(s)
char *s;
{
    extern globinfo global;

    if (filename)
      fprintf(stderr, "\"%s\", line %d near '%s'",
	      filename, global.lineno, yytext);
    else
      fprintf(stderr, "Line %d near '%s'", global.lineno, yytext);

    fprintf(stderr, ": %s\n", s);
}


char *
copystring(src)
char *src;
{
    char *newstring;


    newstring = (char *) malloc(strlen(src)+1);
    strcpy(newstring, src);
    return(newstring);
}


void
free_string(str)
char *str;
{
    if (str)
      free(str, (counter) strlen(str)+1);
}


char *downcase(s)
char *s;
{
    char *os;

    os = s;

    while (*s) {
	if (*s >= 'A' and *s <= 'Z')
	  *s = *s + 32;
	s++;
    }

    return(os);
}


void
do_literal(s)
char *s;
{
    extern char typename[];
    extern int enumval;
    char *os;

    os = s;

    while (*s) {
	if (*s is ' ')
	  *s = '_';
	if (not ((*s >= 'A' and *s <= 'Z') or (*s >= 'a' and *s <= 'z')
		 or *s is '_')) {
	    printf("/* Value '%s' of type %s is %d */\n", os, typename, 
		   enumval++);
	    return;
	}
	s++;
    }

    printf("#define %s__%s %d\n", typename, os, enumval++);
}
