/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: objname.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)objname.ch	1.4 3/13/90";
#endif


#include "cherm.h"
#include "storage.h"

#include "resolve.h"

#include "predefined.cd"
#include "errors.cd"

#define DEFAULT_COMPONENT_COUNT 0
				/* was 1 */
				/* usually there's only one component (.a) */
#define DEFAULT_KEYSET_COUNT 0
				/* was 2 */
				/* generally only one or two keys */
#define DEFAULT_PARAMETER_COUNT 0
				/* was 1 */
				/* most attributes (init) have only 1 parm */


typedef struct res_frame {
    struct res_frame *next;	/* previous stack frame */

    objectp Typename;		/* typename: type resolving against */
    objectp Typedef;		/* type_definition: its definition or nil */

} resolution_stack;

static resolution_stack *rstack, *top_resenv;


static objectp Clist;		/* component_list: built from the */
				/*  object_name and formal_object_name */
				/*  productions. */

static objectp Keyset;

static objectp Formalobjs;


/* fix later: free previous resenv when setting a new one */

void
p_push_resenv(Name)
objectp Name;
{
    objectp lookup_typename();

    resolution_stack *top;


    top = tnew(resolution_stack);
    cdr(top) = rstack;

    top->Typename = Name;
    top->Typedef = lookup_typename(Name);

    rstack = top;
}

void
p_set_resenv(Name)
objectp Name;
{
    rstack = nil;		/* fix later: free what's there? */
    p_push_resenv(Name);
    top_resenv = rstack;
}


void
p_reset_resenv()
{
    rstack = top_resenv;
}




static void 
init_clist()
{
    Clist = new_object();
    vec_new_table(Clist, nil);
}


void
p_init_formal_object_name()
{
    void init_clist();


    init_clist();
}


objectp
p_get_formal_object_name()
{
    return(Clist);
}



void
p_add_component_name(name)
char *name;			/* in string: component name to resolve */
{
    objectp byname_component_lookup();
    objectp bp_component();

    objectp CCompdecl;		/* component_declaration */
    hobject(SCompid, nominal);	/* componentid */
    objectp Compid;		/* componentid */
    resolution_stack *top;


    if (rstack->Typedef) {	/* resolving against a defined entity? */
	CCompdecl = byname_component_lookup(rstack->Typename, name);

	if (CCompdecl) {	/* byname lookup may fail and return nil */
				/*  if name is not a legit component. */
	    copy(SCompid, CCompdecl@Id);
	    insert(Clist, SCompid);
	    p_push_resenv(CCompdecl@component_declaration__type);
	}
    }
    else
      if (rstack->Typename) {
	  Compid = bp_component(name, rstack->Typename);
	  insert(Clist, Compid);

	  top = tnew(resolution_stack); /* set null resolution environment */
	  top->Typename = nil;
	  top->Typedef = nil;
	  cdr(top) = rstack;
	  rstack = top;
      }
      else {
	  fe_error(Stop_Now, errorcode__general_error,
		   "Component '%s' is making me try some fancy backpatching that I can't do yet; complain to Dave", name);
	  /*NOTREACHED*/
      }
		   
}



objectp
byname_component_lookup(Typename, compname)
objectp Typename;		/* constant type_name: record/cm/var type */
char *compname;			/* constant string: component name */
{
    objectp resolve_component();
    objectp lookup_component_declaration();

    objectp CComprec;		/* component_printrec */
    objectp CCompdecl;		/* component_declaration */

    CComprec = resolve_component(Typename, compname);

    if (CComprec) {
	CCompdecl = lookup_component_declaration(Typename, CComprec@component_printrec__component);
	return(CCompdecl);
    }
    else {
	fe_error(LASTPHASE, errorcode__general_error,
		 "'%s' is not a component of type '%s'", compname,
		pmap_type(Typename));
	return(nil);
    }
}


void
p_init_formal_object_name_list()
{
    Formalobjs = new_object();
    vec_new_table(Formalobjs, nil);
}


objectp				/* out formal_objects */
p_get_formal_object_name_list()
{
    return(Formalobjs);
}


void
p_add_formal_object_name(Fob)
objectp Fob;			/* in component_list: formal object name */
{
    insert(Formalobjs, Fob);
}


void
p_init_keyset()
{
    Keyset = new_object();

    ord_avl_new_table(Keyset, whole_key, nil);
}


void
p_add_key(Objlist)
objectp Objlist;		/* in formal_object_list */
{
    if (insert(Keyset, Objlist) is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Duplicate keys");
	discard(Objlist);
    }

}


objectp				/* out keyset */
p_get_keyset()
{
    return(Keyset);
}


objectp Rootname;

void
p_init_object_name(name)
char *name;			/* in string: rootname */
{
    objectp resolve_rootname();
    objectp lookup_root_typename();


    Rootname = resolve_rootname(name);

    if (Rootname) {
	p_set_resenv(lookup_root_typename(Rootname));
	init_clist();
    }
}


objectp
p_get_object_name()
{
    objectp Objname;

    Objname = new_object();
    new_record(Objname, objectname);

    move(Objname@objectname__root, Rootname);
    move(Objname@objectname__components, Clist);

    return(Objname);
}
