-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmthandlername.p	1.1 2/5/92
FmtHandlerName: using (absformat)
process (init: FormatHandlerNameInport)
declare
  fp: formatHandlerNameCall;
begin
  receive fp from init;
  select case of fp.handlerName
  where ('builtin')
    reveal fp.handlerName.builtin;
    select fp.handlerName.builtin
    where ('CaseError')
      fp.formatValue <- "CaseError";
    where ('ConstraintError')
      fp.formatValue <- "ConstraintError";
    where ('ConstraintFailure')
      fp.formatValue <- "ConstraintFailure";
    where ('Depletion')
      fp.formatValue <- "Depletion";
    where ('Disconnected')
      fp.formatValue <- "Disconnected";
    where ('DivideByZero')
      fp.formatValue <- "DivideByZero";
    where ('DuplicateKey')
      fp.formatValue <- "DuplicateKey";
    where ('InterfaceMismatch')
      fp.formatValue <- "InterfaceMismatch";
    where ('NotFound')
      fp.formatValue <- "NotFound";
    where ('PolymorphMismatch')
      fp.formatValue <- "PolymorphMismatch";
    where ('DefinitionError')
      fp.formatValue <- "DefinitionError";
    where ('RangeError')
      fp.formatValue <- "RangeError";
    where ('Uncopyable')
      fp.formatValue <- "Uncopyable";
    otherwise
      exit CantHappen;
    end select;
    
  where ('user')
    reveal fp.handlerName.user;
    fp.formatValue <- fp.formatters.formatType(
      fp.Formatters, fp.Definitions, fp.DefinitionsMap, 
      fp.handlerName.user.type);
    block begin
      inspect defmap in fp.DefinitionsMap[fp.handlerName.user.type.moduleid]
      begin
	inspect emap in defmap.exceptions where
	      (emap.type = fp.handlerName.user.type.typeid and
		emap.exception = fp.handlerName.user.exceptionid) begin
	  merge "." | emap.name into fp.formatValue;
	end inspect;
      end inspect;
    on (notFound)
      merge ".*Unknown-User-Exception*" into fp.formatValue;
    end block;
    
  where ('exit')
    reveal fp.handlerName.exit;
    block begin
      inspect emap in fp.executableMap.exits 
	    where (emap.exit = fp.handlerName.exit) begin
	fp.formatValue <- "exit(" | emap.name | ")";
      end inspect;
    on (notFound)
      fp.formatValue <- "exit(*Unknown-Exit*)";
    end block;
    
  where ('others')
    fp.formatValue <- "Others";
  otherwise
    exit cantHappen;
  end select;
  
  return fp;
  
on exit(cantHappen)
end process
	
