-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getformatters.p
-- Author: Andy Lowry
-- SCCS Info: @(#)getformatters.p	1.4 2/5/92

-- Return a loaded record of absprog formatting capabilities

getFormatters: using (absFormat)
linking (FmtObject, FmtRoot, FmtComps, FmtType, FmtAttrName,
  FmtFmlAttr, FmtFmlTS, FmtAttr, FmtTS, FmtOpcode, FmtStmt, FmtHandlerName)

process (In: getFormattersInport)
declare
  Init: getFormattersCall;
begin
  receive Init from In;
  new Init.Formatters;
  Init.Formatters.FormatObject <- procedure of process FmtObject;
  Init.Formatters.FormatRoot <- procedure of process FmtRoot;
  Init.Formatters.FormatComponents <- procedure of process FmtComps;
  Init.Formatters.FormatType <- procedure of process FmtType;
  Init.Formatters.FormatAttributeName <- procedure of process FmtAttrName;
  Init.Formatters.FormatFormalAttribute <- procedure of process FmtFmlAttr;
  Init.Formatters.FormatFormalTypestate <- procedure of process FmtFmlTS;
  Init.Formatters.FormatAttribute <- procedure of process FmtAttr;
  Init.Formatters.FormatTypestate <- procedure of process FmtTS;
  Init.Formatters.FormatOpcode <- procedure of process FmtOpcode;
  Init.Formatters.FormatStatement <- procedure of process FmtStmt;
  Init.Formatters.FormatHandlerName <- procedure of process FmtHandlerName;
  return Init;
end process
    
