-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkcomponent_list.p
-- Author: Jim Russell
-- SCCS Info: @(#)checkcomponent_list.p	1.3 3/19/91

checkComponent_list: using(checkdefs_internal, errors, positions)
  process (q: checkComponent_listQ)
    -- this checks a component_list to make sure that each entry is a 
    -- valid component of its predecessor, and returns the type of
    -- the whole thing in args.type
  declare
    args: checkcomponent_list;
    error: error;
    errObj: errorObject;
  begin
    receive args from q;
    
    for cid in args.cl[] inspect
        inspect defmod in args.defs[args.type.moduleid]
          begin
            inspect
                prev_type in defmod.type_definitions[args.type.typeid]
              begin
                block
                  begin
                    inspect comp_decl in prev_type.component_declarations where (comp_decl.id = cid)
                      begin
                        args.type := comp_decl.type;
                      end inspect;
                  on (NotFound)
                    error := args.errorTemplate;
                    unite errobj.charstring from 
                    "non-existent component in component list";
                    insert errobj into error.objects;
                    insert error into args.errors;
                    exit error;
                  end block;
              end inspect;
          end inspect;
      end for;
    return args;
  on (NotFound)
    -- Either inspect defmod or inspect prev_type 
    -- above failed.  Don't print error here, since
    -- this will be (was) caught when prev is (was)
    -- checked.  This also means that prev must be
    -- in the same module as cl.  See note in checkdefs.d.
    -- we will however return an error exception to indicate 
    -- that prev is not init
    return args exception error;
  on exit (error)
    return args exception error;
  end process
    
