-- Notes:  
-- 1) This does *not* assign a unique module id to the definitions module
-- it checks.  Thus, users will have to be careful about assigning their
-- own moduleids.
-- 2) This requires that a definitions module library be supplied to check
-- against.  It will automatically add predefined if it's not present, but
-- the user must supply everything else.  Thus, this MUST be compiled so 
-- that the definitions module predefined is not stripped.  
-- I.e. pcom -keeppredef.

checkdefinitions: using(check, initcheck, checkdefs, common, stdenv, fixdefs, 
    fakecheckeddefinitions, terminalio, rmanager) 
  process (init: initcheckdefinitionsQ)
  declare
    initargs: initcheckdefinitionsintf;
    terminal: terminalIO!terminalFunctions;
    rm: rManager!rManager;
    
    checkdefinitionsin: checkdefinitionsQ;
    args: checkdefinitionsintf;
    
    stdenv: stdenv;
    
    typenames: typename_rec;
    predeftn: typename;
    die_disabled: boolean;
    shorten: FixdefsOutport;
    checkdefs: checkdefsFn;
    fakecheckeddefinitions: fakecheckeddefinitionsFn;
    
    die: signalQ;
  begin
    receive initargs from init;
    terminal := initargs.terminal;
    rm := initargs.rm;
    new checkdefinitionsin;
    connect initargs.checkdefinitions to checkdefinitionsin;
    new die;
    connect initargs.finish to die;
    return initargs;
    
    -- Want to delay any real work until we know
    -- we need it, so we do a select first.  We need the disabled flag
    -- to ensure that the first time through the service loop we actually
    -- get the checkin event.
    select
      event checkdefinitionsin
        -- load the programs, below
      event die
        -- shut down checker
        exit done;
      otherwise
        -- this is SO BRAINDAMAGED!  I'm forced to include an otherwise 
        -- clause, but then typestate thinks it's a valid exit path,
        -- so now I have to put in an explicit exit
        exit canthappen;
      end select;
        
    -- build up a stdenv for compiler modules that were written with the
    -- old main interface in mind.  
    new stdenv;
    unwrap stdenv.load from rm.get("load", "") {init};
    unwrap stdenv.pathLoad from rm.get("pathLoad", "") {init};
    unwrap stdenv.readObj from rm.get("readObj", "") {init};
    unwrap stdenv.pathReadObj from rm.get("pathReadObj", "") {init};
    unwrap stdenv.writeObj from rm.get("writeObj", "") {init};
    unwrap stdenv.store from rm.get("store", "") {init};
    unwrap stdenv.libWriteObj from rm.get("libWriteObj", "") {init};
    unwrap stdenv.libStore from rm.get("libStore", "") {init};
    unwrap stdenv.getCwd from rm.get("getCwd", "") {init};
    unwrap stdenv.setCwd from rm.get("setCwd", "") {init};
    stdenv.terminal := terminal;

    -- could only get here if there is a checkdefinitionsin event waiting
    die_disabled <- 'true';
    checkdefs <- procedure of stdenv.pathLoad("checkdefs");
    shorten <- procedure of stdenv.pathLoad("do_shorten");
    fakecheckeddefinitions <- procedure of stdenv.pathLoad("fakecheckeddefinitions");

    -- initialize the typenames from predefined
    new typenames;
    typenames.defmod := \typename predefined!definitions_module\;
    typenames.program := \typename predefined!program\;
    predeftn := \typename predefined!integer\;

  while ('true') repeat
      block declare
          defs: definitions_modules;
        begin
          
          select
            event checkdefinitionsin
              die_disabled <- 'false';
              receive args from checkdefinitionsin;
            event die and where (not die_disabled)
              -- shut down checker
              exit done;
            otherwise
              exit canthappen;
            end select;
        
          -- could only get here if we had a checkdefinitionsin event
      
          -- don't expand abbreviations here; user can do it before calling

          defs := args.defs;
          -- toss in predefined if not already present.
          if not exists of defs[predeftn.moduleid] then
              block
                declare
                  currprog: program;
                begin
                  currprog <- currentprogram;
                  inspect predef in currprog.definitions_modules[predeftn.moduleid]
                    begin
                      insert copy of predef into defs;
                    end inspect;
                on (NotFound)
                  print charstring#"Whoa! predefined not found, and we needed it in checkdefinitions.p!!";
                  exit failed;
                end block;
            end if;
          
          -- run checkdefs on it
          call checkdefs(stdenv, args.module, defs, typenames, 
              args.errors);
          if (size of args.errors <> 0) then
              exit errors;
            end if;

          -- do the shortening
          call shorten(stdenv, args.module, defs, args.errors);
          if (size of args.errors <> 0) then
              exit errors;
            end if;
      
          -- fake the checkeddefinitions attribute
          call fakecheckeddefinitions(args.module);

          return args;
      
        on exit (errors)
          return args exception failure;
        end block;
    end while;
end process
  
