-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)findfile.p	1.9 3/2/92

findfile: using (findfile, initFindFile, common, unix, cwd)
process (initQ: initFindFileQ)

declare
  path: common!charstringList;
  access: fileAccessFn;
  findfileQ: findfile_q;
  getCwd: cwd!getCwdFn;
  normalize: normalizePathFn;
begin
  block -- initialization block
  declare
    initArgs: initFindFile;
    upath: charstring;
  begin
    receive initArgs from initQ;

    -- convert the hokey unix-style colon-separated string into an
    -- charstringList 

    upath := initArgs.path;
    new path;

    block declare
      part: charstring;
      colpos: integer;
      char: char;
    begin
      -- make sure last char is a colon, so following loop will
      -- process all the pieces
      insert char#':' into upath;
      while boolean#(integer#(size of upath) > integer#0) repeat
	colpos <- integer#(position of c in upath where
	      (boolean#(c = char#':')));
	extract part from c in upath where
	    (boolean#(integer#(position of c) < colpos));
	-- all components must have a trailing slash
	if boolean#(char#(c in part where 
		  (boolean#(integer#(position of c) = 
		      integer#(integer#(size of part) - integer#1))))
		<> char#'/') then
	  insert char#'/' into part;
	end if;
	-- can't pre-normalize individual parts since cwd may change
	insert part into path;
	-- get rid of the colon
	remove char from c in upath where
	    (boolean#(integer#(position of c) = integer#0));
      end while;
    end block;

    -- create the service port and return it

    access := initArgs.access;
    getCwd := initArgs.getCwd;

    new findfileQ;
    connect initArgs.pathfunc to findfileQ;
    
    return initArgs;
    discard initQ;
  end block;

  -- cons up a normalizing process
  normalize <- normalizePathFn#(procedure of program#(
      process (Q: normalizePathQ)
      declare
	args: normalizePath;
	path: charstring;
	ndots: integer;
	slashpos: integer;
	initial: boolean;
	junk: charstring;
      begin
	receive args from Q;
	
	if boolean#(integer#(size of args.path) = integer#0) then
	  return args exception impossible;
	  exit done;
	else
	  new args.normalized;
	  if boolean#(char#(args.path[]) = char#'/') then
	    path := args.path;
	  else
	    path <- charstring#(args.cwd | args.path);
	  end if;
	  ndots <- integer#0;
	  initial <- boolean#'true';
	  for c in path[] inspect
	    if boolean#(c = char#'/') then
	      if boolean#(ndots = integer#0) then
		-- this is just tying off a normal directory component.
	      else
		if boolean#(ndots = integer#2) then
		  -- back up one directory and reset ndots
		  slashpos <- integer#-1;
		  for char in args.normalized[] inspect
		    if boolean#(char = char#'/') then
		      slashpos <- integer#(position of char);
		    end if;
		  end for;
		  if boolean#(slashpos < integer#0) then
		    return args exception impossible;-- can't back up
		    exit done;
		  else
		    -- move back to start of parent directory
		    extract junk from char in args.normalized where
			(boolean#(integer#(position of char) >= slashpos));
		  end if;
		  ndots <- integer#0;
		else
		  if boolean#(ndots = integer#1) then
		    -- current directory... nothing changes, but reset ndots
		    ndots <- integer#0;
		  else
		    -- more than two dots is a normal directory name
		    -- add slash to start this component, then all the dots
		    insert char#'/' into args.normalized;
		    while boolean#(ndots > integer#0) repeat
		      insert char#'.' into args.normalized;
		      ndots <- integer#(ndots - integer#1);
		    end while;
		  end if;
		end if;
	      end if;
	      initial <- boolean#'true';
	    else
	      if boolean#(c = char#'.') then
		-- just count initial dots
		if initial then
		  ndots <- integer#(ndots + integer#1);
		else
		  insert char#'.' into args.normalized;
		end if;
	      else
		-- normal directory char.. if we're initial, fill in
		-- component so far
		if initial then
		  insert char#'/' into args.normalized;
		  while boolean#(ndots > integer#0) repeat
		    insert char#'.' into args.normalized;
		    ndots <- integer#(ndots - integer#1);
		  end while;
		  initial <- boolean#'false';
		end if;
		insert char#(copy of c) into args.normalized;
	      end if;
	    end if;
	  end for;
	  -- deal with trailing dots component if any
	  if initial then
	    if boolean#(ndots >= integer#3) then
	      -- final component was normal.. fill in the dots
	      insert char#'/' into args.normalized;
	      while boolean#(ndots > integer#0) repeat
		insert char#'.' into args.normalized;
		ndots <- integer#(ndots - integer#1);
	      end while;
	    else
	      if boolean#(ndots = integer#2) then
		-- back up one directory
		slashpos <- integer#-1;
		for c in args.normalized[] inspect
		  if boolean#(c = char#'/') then
		    slashpos <- integer#(position of c);
		  end if;
		end for;
		if boolean#(slashpos < integer#0) then
		  return args exception impossible;-- couldn't back up
		  exit done;
		else
		  extract junk from c in args.normalized where
		      (boolean#(integer#(position of c) >= slashpos));
		end if;
	      else
		if boolean#(ndots = integer#1) then
		  -- final dot component changed nothing
		else
		  -- ndots = 0 -- input path must have ended in a slash
		  insert char#'/' into args.normalized;
		end if;
	      end if;
	    end if;
	  end if;
	end if;

	return args;
      on exit(done)
      end process));
  

  -- go into an infinite service loop

  while boolean#'true' repeat
    block declare
      args: findfile_intf;
      cwd: charstring;
      trypath: charstring;
    begin
      receive args from findfileQ;
    
      if boolean#(integer#(size of args.file) = integer#0) then
	exit notFound;		-- can't find a file with no name
      end if;

      if boolean#(char#(args.file[]) = char#'/') then
	-- absolute path name... check if we have access, and
	-- normalize it if we do
	block begin
	  if boolean#(access(args.file, args.mode)) then
	    -- note that cwd won't be used, so we just pass a placeholder
	    args.foundfile <- charstring#(normalize(args.file,charstring#""));
	    return args;
	    exit done;
	  else
	    exit notFound;	-- no access
	  end if;
	on (normalizePath.impossible)
	  exit notFound;	-- impossible path, so no file found
	end block;
	
      else			-- relative path name.. try search paths
	cwd <- charstring#(getCwd());
	insert char#'/' into cwd;
	for dir in path[] inspect
	  block begin
	    trypath <- charstring#(dir | args.file);
	    if boolean#(char#(trypath[]) <> char#'/') then
	      trypath <- charstring#(cwd | trypath);
	    end if;
	    if boolean#(access(trypath, args.mode)) then
	      args.foundfile <- charstring#(normalize(trypath, cwd));
	      return args;
	      exit done;
	    end if;
	  on (normalizePath.impossible)
	  end block;
	end for;

	-- failed on all path compoents... forget it
	exit notFound;
      end if;
    on exit(notFound)
      return args exception file_not_found;
    on exit(done)
    end block;
  end while;
on (disconnected)
end process
