/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* Makefile */
/* Author: Andy Lowry */
/* SCCS Info: @(#)Makefile	1.11 2/7/92 */

/* This make file generates assembler sources (.li files) for various */
/* core modules needed to bootstrap the Hermes system. */

/* Set the default target here at the top so there's no confusion... */
all:	initial
initial::

/* Get standard definitions and suffix rules */
#include "includefile"

/* Add our special suffix */
.SUFFIXES:
.SUFFIXES:	.lipp .pp .p .li .po $(SUFFIXES)

/* Where to load .po files from... */
LOADPATH =	$(PROCDIR)
/* Where to load .do files from */
DEFPATH =	$(GENHROOT)/bin:$(HROOT)/hermes/defs:$(DEFDIR)
/* Normally we're just working with a single system */
GENHROOT =	$(HROOT)
/* Additional cpp flags we need */
EXTRACPPFLAGS =	-DCGBOOT -undef

/* Suffix rules for generating .li files */
.p.li:	$<
	$*
.lipp.li: $<
	$(CPP) $(HCPPFLAGS) < $< > $@
/* how to assemble an li file */
.li.po: $<
	$(ENV) $(HERMENV) PREDEFINEDMODULE=$(HROOT)/bin/predefined.do \
		$(ASM) $<

/* Files needed from source directory */
PPFILES =	pcom.pp root.pp getpaths.pp
SRCPFILES =	findfile.p pathload.p pathreadobj.p loadprog.p \
		load_program.p store_program.p rmanager.p userrm.p
LIPPFILES =	listuff.lipp liunstuff.lipp
SOURCES =	$(PPFILES) $(SRCPFILES) $(LIPPFILES)
/* Where they come from */
SRCDIR =	$(HROOT)/hermes
/* Generated Hermes source files */
GENPFILES =	root.p pcom.p
/* LI source files to be built */
LIFILES =	root.li pcom.li findfile.li pathload.li pathreadobj.li \
		loadprog.li load_program.li store_program.li \
		rmanager.li userrm.li
ASMLIFILES =	listuff.li liunstuff.li
POFILES = 	listuff.po liunstuff.po

/* Produce the LI files */
all:	$(SOURCES) $(GENPFILES) $(POFILES)
	@lilist=`$(MAKE) -n lilist HROOT=$(HROOT) GENHROOT=$(GENHROOT)` ; \
		if [ "$$lilist" ] ; then \
		  echo "$(LIGENCMD) " $$lilist ; $(LIGENCMD) $$lilist ; fi

lilist:	$(LIFILES)

install: all
	cp $(LIFILES) $(HROOT)/hermes/liboot

/* Command to produce LI sources */
LIGENCMD =	$(ENV) $(HERMENV) PCOMnotcheck= PCOMnotscheck= PCOMligen= \
			PCOMnoobject= $(HERMES) $(PCOM)

/* Dependencies for all modules */
root.li:	root.p
root.p:		root.pp getpaths.pp

pcom.li:	pcom.p $(POFILES)
pcom.p:		pcom.pp

findfile.li:	findfile.p

pathload.li:	pathload.p

pathreadobj.li:	pathreadobj.p

loadprog.li:	loadprog.p

load_program.li:	load_program.p

store_program.li:	store_program.p

rmanager.li: rmanager.p

userrm.li: userrm.p

listuff.po:	listuff.li
listuff.li:	listuff.lipp

liunstuff.po:	liunstuff.li
liunstuff.li:	liunstuff.lipp

/* Get symbolic links to sources as needed */

$(SOURCES):
	@ if [ -f $@ ] ; then rm $@ ; fi
	ln -s $(SRCDIR)/$@
	
/* Clean up the directory */
clean::
	rm -f $(GENPFILES) $(LIFILES) $(ASMLIFILES) $(SOURCES)
