-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)checking_table.d	1.2 3/13/90

checking_table: using (predefined, type_inference, typestate_inference)
definitions

  checking_table: table of checking_record { full } keys (operator);

  checking_record: record (
    operator: predefined!operator,
    operand_count: opt_integer,
    qualifier: predefined!qualifier_types,
    qualifier_info: qualifier_info,

    -- type rules
    type_inference_rules: type_inference_rules,
    type_assignment_rules: type_assignment_rules,
    type_class_rules: type_class_rules,

    -- typestate rules 
    precondition_rules: precondition_rules,
    postcondition_rules: postcondition
  );

opt_integer: variant of option
 (
  'present' -> value: integer {full},
  'absent' -> empty: empty {}
  );


-- qualifier_info gives the operand position of the table for the selector when
-- the qualifier is a selector or a for-inspect (which contains a selector).

  qualifier_selects: enumeration ( 'selector', 'normal' );

  qualifier_info: variant of qualifier_selects (
    'normal'		-> normal: empty { },
    'selector'		-> selector: integer { full }
  );


  

end definitions
