-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: codegen.d
-- Author: Andy Lowry
-- SCCS Info: @(#)codegen.d	1.11 2/4/92

-- This is the interface to the code generator.  A call on the
-- initialization supplies an absprog and produces a capability to
-- compile individual processes from that absprog. 

-- Additional initialization arguments are a table of "annotations"
-- and a table of options.  The annotations are labeled bits of
-- information pertaining to the absprog.  Some annotations, such as
-- infferred types, might be required by the code generator.  Others,
-- such as root object print names, source text, etc., can help the
-- code generator produce more helpful error messages or more readable
-- assembly source.

-- The 'options' table provides a mechanism for turning on or off
-- various options in the codegen, such as certain types of
-- optimization or the production of assembly source code.

codegen: using (annotate, load, objectIO, interpform, errors)

definitions

  codegenInit: callmessage (
    absprog: program,		-- progam to compile
    annotations: annotations,	-- auxiliary info attached to absprog
    options: annotations,	-- codegen option specs
    pathLoad: load_func,
    pathReadObj: readobject_func,
    codegen: codegenFn		-- capability to compile individual processes
  )
  constant (absprog, annotations, options, pathLoad, pathReadObj)
  exit {full};
  codegenInitQ: inport of codegenInit {
    full(absprog), init(annotations), init(options),
    init(pathLoad), init(pathReadObj)};
  codegenInitFn: outport of codegenInitQ;

  codegen: callmessage (
    proc: predefined!proc,	-- process to be compiled
    code: interpform!prog,	-- the compiled code
    errors: errors
  )
  constant (proc)
  exit {full(proc), full(code)}
  exception codegenErrors {full(proc), init(errors)};
  codegenQ: inport of codegen {full(proc)};
  codegenFn: outport of codegenQ;

end definitions
